/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.graph;

import com.swirlds.common.metrics.noop.NoOpMetrics;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.event.linking.ConsensusLinker;
import com.swirlds.platform.event.linking.NoOpLinkerLogsAndMetrics;
import com.swirlds.platform.event.orphan.DefaultOrphanBuffer;
import com.swirlds.platform.gossip.IntakeEventCounter;
import com.swirlds.platform.gossip.NoOpIntakeEventCounter;
import com.swirlds.platform.internal.EventImpl;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.model.event.PlatformEvent;

public class SimpleGraph {
    private final Random random;
    private final List<PlatformEvent> events;
    private final List<EventImpl> eventImpls;

    public SimpleGraph(@NonNull Random random, PlatformEvent ... events) {
        this.random = random;
        this.events = List.of(events);
        ArrayList<EventImpl> eventImpls = new ArrayList<EventImpl>();
        DefaultOrphanBuffer orphanBuffer = new DefaultOrphanBuffer((Metrics)new NoOpMetrics(), (IntakeEventCounter)new NoOpIntakeEventCounter());
        ConsensusLinker consensusLinker = new ConsensusLinker(NoOpLinkerLogsAndMetrics.getInstance());
        for (PlatformEvent event : events) {
            List unorphanedEvents = orphanBuffer.handleEvent(event);
            if (unorphanedEvents.size() != 1) {
                throw new IllegalArgumentException("All events in the simple graph must be non-orphans");
            }
            EventImpl linkedEvent = consensusLinker.linkEvent(event);
            if (linkedEvent == null) {
                throw new IllegalArgumentException("Failed to link event in simple graph");
            }
            if (event.getConsensusTimestamp() != null) {
                linkedEvent.setConsensus(true);
            }
            eventImpls.add(linkedEvent);
        }
        this.eventImpls = Collections.unmodifiableList(eventImpls);
    }

    @NonNull
    public List<PlatformEvent> events() {
        return this.events;
    }

    @NonNull
    public PlatformEvent event(int index) {
        return this.events.get(index);
    }

    @NonNull
    public List<PlatformEvent> events(int ... indices) {
        ArrayList<PlatformEvent> selectedEvents = new ArrayList<PlatformEvent>();
        for (int index : indices) {
            selectedEvents.add(this.events.get(index));
        }
        return Collections.unmodifiableList(selectedEvents);
    }

    @NonNull
    public Set<PlatformEvent> eventSet(int ... indices) {
        HashSet<PlatformEvent> eventSet = new HashSet<PlatformEvent>();
        for (int index : indices) {
            eventSet.add(this.events.get(index));
        }
        return Collections.unmodifiableSet(eventSet);
    }

    @NonNull
    public List<EventImpl> impls() {
        return this.eventImpls;
    }

    @NonNull
    public List<EventImpl> shuffledImpls() {
        ArrayList<EventImpl> shuffledEvents = new ArrayList<EventImpl>(this.eventImpls);
        Collections.shuffle(shuffledEvents, this.random);
        return shuffledEvents;
    }

    @NonNull
    public List<EventImpl> impls(int ... indices) {
        ArrayList<EventImpl> selectedEvents = new ArrayList<EventImpl>();
        for (int index : indices) {
            selectedEvents.add(this.eventImpls.get(index));
        }
        return Collections.unmodifiableList(selectedEvents);
    }

    @NonNull
    public EventImpl impl(int index) {
        return this.eventImpls.get(index);
    }

    @NonNull
    public Set<Hash> hashes(int ... indices) {
        return this.events(indices).stream().map(PlatformEvent::getHash).collect(Collectors.toSet());
    }
}

