/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.cache;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.base.state.MutabilityException;
import com.swirlds.common.FastCopyable;
import com.swirlds.common.threading.framework.config.ThreadConfiguration;
import com.swirlds.common.threading.manager.AdHocThreadManager;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.virtualmap.config.VirtualMapConfig;
import com.swirlds.virtualmap.constructable.constructors.VirtualNodeCacheConstructor;
import com.swirlds.virtualmap.datasource.VirtualHashRecord;
import com.swirlds.virtualmap.datasource.VirtualLeafBytes;
import com.swirlds.virtualmap.internal.cache.ConcurrentArray;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.ToLongFunction;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.concurrent.futures.StandardFuture;
import org.hiero.base.constructable.ConstructableClass;
import org.hiero.base.crypto.Hash;
import org.hiero.base.exceptions.PlatformException;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

@ConstructableClass(value=5275760189460016428L, constructorType=VirtualNodeCacheConstructor.class)
public final class VirtualNodeCache
implements FastCopyable,
SelfSerializable {
    private static final Logger logger = LogManager.getLogger(VirtualNodeCache.class);
    public static final long CLASS_ID = 5275760189460016428L;
    public static final VirtualLeafBytes<?> DELETED_LEAF_RECORD = new VirtualLeafBytes<Object>(-1L, Bytes.EMPTY, null, null);
    public static final Hash NULL_HASH = new Hash();
    private static Executor cleaningPool = null;
    private final AtomicLong fastCopyVersion = new AtomicLong(0L);
    private final AtomicReference<VirtualNodeCache> next = new AtomicReference();
    private final AtomicReference<VirtualNodeCache> prev = new AtomicReference();
    private final Map<Bytes, Mutation<Bytes, VirtualLeafBytes>> keyToDirtyLeafIndex;
    private final Map<Long, Mutation<Long, Bytes>> pathToDirtyLeafIndex;
    private final Map<Long, Mutation<Long, Hash>> pathToDirtyHashIndex;
    private final AtomicBoolean released = new AtomicBoolean(false);
    private final AtomicBoolean leafIndexesAreImmutable = new AtomicBoolean(false);
    private final AtomicBoolean hashesAreImmutable = new AtomicBoolean(true);
    private volatile ConcurrentArray<Mutation<Bytes, VirtualLeafBytes>> dirtyLeaves = new ConcurrentArray();
    private volatile ConcurrentArray<Mutation<Long, Bytes>> dirtyLeafPaths = new ConcurrentArray();
    private volatile ConcurrentArray<Mutation<Long, Hash>> dirtyHashes = new ConcurrentArray();
    private final AtomicLong estimatedLeavesSizeInBytes = new AtomicLong(0L);
    private final AtomicLong estimatedLeafPathsSizeInBytes = new AtomicLong(0L);
    private final AtomicLong estimatedHashesSizeInBytes = new AtomicLong(0L);
    private final AtomicBoolean mergedCopy = new AtomicBoolean(false);
    private final ReentrantLock releaseLock;
    private final AtomicBoolean snapshot = new AtomicBoolean(false);
    private final AtomicLong lastReleased;
    @NonNull
    private final VirtualMapConfig virtualMapConfig;

    private static synchronized Executor getCleaningPool(@NonNull VirtualMapConfig virtualMapConfig) {
        Objects.requireNonNull(virtualMapConfig);
        if (cleaningPool == null) {
            cleaningPool = Boolean.getBoolean("syncCleaningPool") ? Runnable::run : new ThreadPoolExecutor(virtualMapConfig.getNumCleanerThreads(), virtualMapConfig.getNumCleanerThreads(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), ((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setThreadGroup(new ThreadGroup("virtual-cache-cleaners"))).setComponent("virtual-map")).setThreadName("cache-cleaner")).setExceptionHandler((t, ex) -> logger.error(LogMarker.EXCEPTION.getMarker(), "Failed to purge unneeded key/mutationList pairs", ex))).buildFactory());
        }
        return cleaningPool;
    }

    public VirtualNodeCache(@NonNull VirtualMapConfig virtualMapConfig) {
        this(virtualMapConfig, 0L);
    }

    public VirtualNodeCache(@NonNull VirtualMapConfig virtualMapConfig, long fastCopyVersion) {
        this.keyToDirtyLeafIndex = new ConcurrentHashMap<Bytes, Mutation<Bytes, VirtualLeafBytes>>();
        this.pathToDirtyLeafIndex = new ConcurrentHashMap<Long, Mutation<Long, Bytes>>();
        this.pathToDirtyHashIndex = new ConcurrentHashMap<Long, Mutation<Long, Hash>>();
        this.releaseLock = new ReentrantLock();
        this.lastReleased = new AtomicLong(-1L);
        this.fastCopyVersion.set(fastCopyVersion);
        this.virtualMapConfig = Objects.requireNonNull(virtualMapConfig);
    }

    private VirtualNodeCache(VirtualNodeCache source) {
        this.fastCopyVersion.set(source.fastCopyVersion.get() + 1L);
        this.keyToDirtyLeafIndex = source.keyToDirtyLeafIndex;
        this.pathToDirtyLeafIndex = source.pathToDirtyLeafIndex;
        this.pathToDirtyHashIndex = source.pathToDirtyHashIndex;
        this.releaseLock = source.releaseLock;
        this.lastReleased = source.lastReleased;
        this.virtualMapConfig = source.virtualMapConfig;
        source.prepareForHashing();
        this.next.set(source);
        source.prev.set(this);
    }

    public VirtualNodeCache copy() {
        return new VirtualNodeCache(this);
    }

    public void prepareForHashing() {
        this.leafIndexesAreImmutable.set(true);
        this.hashesAreImmutable.set(false);
        this.dirtyLeaves.seal();
    }

    public boolean isImmutable() {
        return this.leafIndexesAreImmutable.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean release() {
        this.throwIfDestroyed();
        this.seal();
        AtomicLong atomicLong = this.lastReleased;
        synchronized (atomicLong) {
            this.lastReleased.set(this.fastCopyVersion.get());
        }
        this.releaseLock.lock();
        try {
            if (this.next.get() != null) {
                throw new IllegalStateException("Cannot release an intermediate version, must release the oldest");
            }
            this.released.set(true);
            this.wirePrevAndNext();
        }
        finally {
            this.releaseLock.unlock();
        }
        VirtualNodeCache.purge(this.dirtyLeaves, this.keyToDirtyLeafIndex, this.virtualMapConfig);
        VirtualNodeCache.purge(this.dirtyLeafPaths, this.pathToDirtyLeafIndex, this.virtualMapConfig);
        VirtualNodeCache.purge(this.dirtyHashes, this.pathToDirtyHashIndex, this.virtualMapConfig);
        this.estimatedLeavesSizeInBytes.set(0L);
        this.estimatedLeafPathsSizeInBytes.set(0L);
        this.estimatedHashesSizeInBytes.set(0L);
        this.dirtyLeaves = null;
        this.dirtyLeafPaths = null;
        this.dirtyHashes = null;
        if (logger.isTraceEnabled()) {
            logger.trace(LogMarker.VIRTUAL_MERKLE_STATS.getMarker(), "Released {}", (Object)this.fastCopyVersion);
        }
        return true;
    }

    public boolean isDestroyed() {
        return this.released.get();
    }

    public void merge() {
        this.releaseLock.lock();
        try {
            VirtualNodeCache p = this.prev.get();
            if (p == null) {
                throw new IllegalStateException("Cannot merge with a null cache");
            }
            if (!p.hashesAreImmutable.get() || !this.hashesAreImmutable.get()) {
                throw new IllegalStateException("You can only merge caches that are sealed");
            }
            p.dirtyLeaves.merge(this.dirtyLeaves);
            p.dirtyLeafPaths.merge(this.dirtyLeafPaths);
            p.dirtyHashes.merge(this.dirtyHashes);
            p.estimatedLeavesSizeInBytes.addAndGet(this.estimatedLeavesSizeInBytes.get());
            p.estimatedLeafPathsSizeInBytes.addAndGet(this.estimatedLeafPathsSizeInBytes.get());
            p.estimatedHashesSizeInBytes.addAndGet(this.estimatedHashesSizeInBytes.get());
            p.mergedCopy.set(true);
            this.wirePrevAndNext();
        }
        finally {
            this.releaseLock.unlock();
            if (logger.isTraceEnabled()) {
                logger.trace(LogMarker.VIRTUAL_MERKLE_STATS.getMarker(), "Merged version {}, {} dirty leaves, {} dirty internals", (Object)this.fastCopyVersion, (Object)this.dirtyLeaves.size(), (Object)this.dirtyHashes.size());
            }
        }
    }

    public void seal() {
        this.leafIndexesAreImmutable.set(true);
        this.hashesAreImmutable.set(true);
        this.dirtyLeaves.seal();
        this.dirtyHashes.seal();
        this.dirtyLeafPaths.seal();
        this.estimatedHashesSizeInBytes.addAndGet(this.dirtyHashes.estimatedStorageMemoryOverhead());
        this.estimatedLeavesSizeInBytes.addAndGet(this.dirtyLeaves.estimatedStorageMemoryOverhead());
        this.estimatedLeafPathsSizeInBytes.addAndGet(this.dirtyLeafPaths.estimatedStorageMemoryOverhead());
    }

    public void putLeaf(@NonNull VirtualLeafBytes leaf) {
        this.throwIfLeafImmutable();
        Objects.requireNonNull(leaf);
        Bytes key = leaf.keyBytes();
        assert (key != Bytes.EMPTY) : "Keys cannot be empty";
        assert (key.length() > 0L) : "Keys cannot be empty";
        this.updatePaths(key, this.estimatedLeafPathsSizeInBytes, Bytes::length, leaf.path(), this.pathToDirtyLeafIndex, this.dirtyLeafPaths);
        this.keyToDirtyLeafIndex.compute(key, (k, mutations) -> this.mutate(leaf, (Mutation<Bytes, VirtualLeafBytes>)mutations));
    }

    public void deleteLeaf(@NonNull VirtualLeafBytes leaf) {
        this.throwIfLeafImmutable();
        Objects.requireNonNull(leaf);
        this.clearLeafPath(leaf.path());
        Bytes key = leaf.keyBytes();
        assert (key != Bytes.EMPTY) : "Keys cannot be empty";
        assert (key.length() > 0L) : "Keys cannot be empty";
        this.keyToDirtyLeafIndex.compute(key, (k, mutations) -> {
            mutations = this.mutate(leaf, (Mutation<Bytes, VirtualLeafBytes>)mutations);
            mutations.setDeleted(true);
            assert (this.pathToDirtyLeafIndex.get(leaf.path()).isDeleted()) : "It should be deleted too";
            return mutations;
        });
    }

    public void clearLeafPath(long path) {
        this.throwIfLeafImmutable();
        this.updatePaths(null, this.estimatedLeafPathsSizeInBytes, Bytes::length, path, this.pathToDirtyLeafIndex, this.dirtyLeafPaths);
    }

    public VirtualLeafBytes lookupLeafByKey(Bytes key) {
        Objects.requireNonNull(key);
        if (this.released.get()) {
            return null;
        }
        Mutation<Bytes, VirtualLeafBytes> mutation = this.lookup(this.keyToDirtyLeafIndex.get(key));
        if (mutation == null) {
            return null;
        }
        if (mutation.isDeleted()) {
            return DELETED_LEAF_RECORD;
        }
        return (VirtualLeafBytes)mutation.value;
    }

    public VirtualLeafBytes lookupLeafByPath(long path) {
        if (this.released.get()) {
            return null;
        }
        Mutation<Long, Bytes> mutation = this.lookup(this.pathToDirtyLeafIndex.get(path));
        if (mutation == null) {
            return null;
        }
        return mutation.isDeleted() ? DELETED_LEAF_RECORD : this.lookupLeafByKey((Bytes)mutation.value);
    }

    public Stream<VirtualLeafBytes> dirtyLeavesForHash(long firstLeafPath, long lastLeafPath) {
        if (this.mergedCopy.get()) {
            throw new IllegalStateException("Cannot get dirty leaves for hashing on a merged cache copy");
        }
        Stream<VirtualLeafBytes> result = this.dirtyLeaves(firstLeafPath, lastLeafPath, false);
        return result.sorted(Comparator.comparingLong(VirtualLeafBytes::path));
    }

    public Stream<VirtualLeafBytes> dirtyLeavesForFlush(long firstLeafPath, long lastLeafPath) {
        return this.dirtyLeaves(firstLeafPath, lastLeafPath, true);
    }

    private Stream<VirtualLeafBytes> dirtyLeaves(long firstLeafPath, long lastLeafPath, boolean dedupe) {
        if (!this.dirtyLeaves.isImmutable()) {
            throw new MutabilityException("Cannot call on a cache that is still mutable for dirty leaves");
        }
        if (dedupe) {
            VirtualNodeCache.filterMutations(this.dirtyLeaves, this.virtualMapConfig);
        }
        return this.dirtyLeaves.stream().filter(mutation -> {
            long path = ((VirtualLeafBytes)mutation.value).path();
            return path >= firstLeafPath && path <= lastLeafPath;
        }).filter(mutation -> {
            assert (dedupe || mutation.notFiltered());
            return mutation.notFiltered();
        }).filter(mutation -> !mutation.isDeleted()).map(mutation -> (VirtualLeafBytes)mutation.value);
    }

    public Stream<VirtualLeafBytes> deletedLeaves() {
        if (!this.dirtyLeaves.isImmutable()) {
            throw new MutabilityException("Cannot call on a cache that is still mutable for dirty leaves");
        }
        ConcurrentHashMap leaves = new ConcurrentHashMap();
        StandardFuture<Void> result = this.dirtyLeaves.parallelTraverse(VirtualNodeCache.getCleaningPool(this.virtualMapConfig), element -> {
            Bytes key;
            Mutation<Bytes, VirtualLeafBytes> mutation;
            if (element.isDeleted() && (mutation = this.lookup(this.keyToDirtyLeafIndex.get(key = (Bytes)element.key))) != null && mutation.isDeleted()) {
                leaves.putIfAbsent(key, (VirtualLeafBytes)element.value);
            }
        });
        try {
            result.getAndRethrow();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new PlatformException("VirtualNodeCache.deletedLeaves() interrupted", (Throwable)ex, LogMarker.EXCEPTION);
        }
        return leaves.values().stream();
    }

    public void putHash(VirtualHashRecord node) {
        Objects.requireNonNull(node);
        this.putHash(node.path(), node.hash());
    }

    public void putHash(long path, Hash hash) {
        this.throwIfInternalsImmutable();
        Hash value = hash != null ? hash : NULL_HASH;
        this.updatePaths(value, this.estimatedHashesSizeInBytes, Hash::getSerializedLength, path, this.pathToDirtyHashIndex, this.dirtyHashes);
    }

    public Hash lookupHashByPath(long path) {
        if (this.released.get()) {
            return null;
        }
        Mutation<Long, Hash> mutation = this.lookup(this.pathToDirtyHashIndex.get(path));
        if (mutation == null || mutation.value == NULL_HASH) {
            return null;
        }
        return (Hash)mutation.value;
    }

    public Stream<VirtualHashRecord> dirtyHashesForFlush(long lastLeafPath) {
        if (!this.dirtyHashes.isImmutable()) {
            throw new MutabilityException("Cannot get the dirty internal records for a non-sealed cache.");
        }
        VirtualNodeCache.filterMutations(this.dirtyHashes, this.virtualMapConfig);
        return this.dirtyHashes.stream().filter(mutation -> (Long)mutation.key <= lastLeafPath).filter(Mutation::notFiltered).map(mutation -> new VirtualHashRecord((Long)mutation.key, mutation.value != NULL_HASH ? (Hash)mutation.value : null));
    }

    public long getClassId() {
        return 5275760189460016428L;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        if (!this.snapshot.get()) {
            throw new IllegalStateException("Trying to serialize a non-snapshot instance");
        }
        out.writeLong(this.fastCopyVersion.get());
        this.serializeKeyToDirtyLeafIndex(this.keyToDirtyLeafIndex, out);
        this.serializePathToDirtyLeafIndex(this.pathToDirtyLeafIndex, out);
        this.serializePathToDirtyHashIndex(this.pathToDirtyHashIndex, out);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.fastCopyVersion.set(in.readLong());
        this.deserializeKeyToDirtyLeafIndex(this.keyToDirtyLeafIndex, in, version);
        this.deserializePathToDirtyLeafIndex(this.pathToDirtyLeafIndex, in);
        this.deserializePathToDirtyHashIndex(this.pathToDirtyHashIndex, in, version);
    }

    public int getVersion() {
        return 2;
    }

    public long getFastCopyVersion() {
        return this.fastCopyVersion.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualNodeCache snapshot() {
        AtomicLong atomicLong = this.lastReleased;
        synchronized (atomicLong) {
            VirtualNodeCache newSnapshot = new VirtualNodeCache(this.virtualMapConfig);
            this.setMapSnapshotAndArray(this.pathToDirtyHashIndex, newSnapshot.pathToDirtyHashIndex, newSnapshot.dirtyHashes);
            this.setMapSnapshotAndArray(this.pathToDirtyLeafIndex, newSnapshot.pathToDirtyLeafIndex, newSnapshot.dirtyLeafPaths);
            this.setMapSnapshotAndArray(this.keyToDirtyLeafIndex, newSnapshot.keyToDirtyLeafIndex, newSnapshot.dirtyLeaves);
            newSnapshot.snapshot.set(true);
            newSnapshot.fastCopyVersion.set(this.fastCopyVersion.get());
            newSnapshot.seal();
            return newSnapshot;
        }
    }

    private void wirePrevAndNext() {
        VirtualNodeCache n = this.next.get();
        VirtualNodeCache p = this.prev.get();
        if (n != null) {
            n.prev.set(p);
        }
        if (p != null) {
            p.next.set(n);
        }
        this.next.set(null);
        this.prev.set(null);
    }

    private <V> void updatePaths(V value, @NonNull AtomicLong estimatedSize, @NonNull ToLongFunction<V> getValueSize, long path, Map<Long, Mutation<Long, V>> index, ConcurrentArray<Mutation<Long, V>> dirtyPaths) {
        index.compute(path, (key, mutation) -> {
            Mutation<Object, Object> nextMutation = mutation;
            Mutation previousMutation = null;
            while (nextMutation != null && nextMutation.version > this.fastCopyVersion.get()) {
                previousMutation = nextMutation;
                nextMutation = nextMutation.next;
            }
            long sizeDelta = 0L;
            if (nextMutation == null || nextMutation.version != this.fastCopyVersion.get()) {
                nextMutation = new Mutation<Long, Object>(nextMutation, path, value, this.fastCopyVersion.get());
                sizeDelta += 80L;
                nextMutation.setDeleted(value == null);
                dirtyPaths.add(nextMutation);
                if (value != null) {
                    sizeDelta += getValueSize.applyAsLong(value);
                }
            } else if (nextMutation.value != value) {
                assert (nextMutation.notFiltered());
                if (nextMutation.value != null) {
                    sizeDelta -= getValueSize.applyAsLong(nextMutation.value);
                }
                nextMutation.value = value;
                nextMutation.setDeleted(value == null);
                if (value != null) {
                    sizeDelta += getValueSize.applyAsLong(nextMutation.value);
                }
            }
            if (previousMutation != null) {
                assert (previousMutation.notFiltered());
                previousMutation.next = nextMutation;
            } else {
                mutation = nextMutation;
            }
            estimatedSize.addAndGet(sizeDelta);
            return mutation;
        });
    }

    private <K, V> Mutation<K, V> lookup(Mutation<K, V> mutation) {
        while (mutation != null) {
            if (mutation.version <= this.fastCopyVersion.get()) {
                return mutation;
            }
            mutation = mutation.next;
        }
        return null;
    }

    private Mutation<Bytes, VirtualLeafBytes> mutate(@NonNull VirtualLeafBytes leaf, @Nullable Mutation<Bytes, VirtualLeafBytes> mutation) {
        long sizeDelta = 0L;
        if (mutation == null || mutation.version != this.fastCopyVersion.get()) {
            Mutation<Bytes, VirtualLeafBytes> newerMutation = new Mutation<Bytes, VirtualLeafBytes>(mutation, leaf.keyBytes(), leaf, this.fastCopyVersion.get());
            sizeDelta += 128L;
            this.dirtyLeaves.add(newerMutation);
            mutation = newerMutation;
            sizeDelta += (long)leaf.getSizeInBytes();
        } else if (mutation.value != leaf) {
            assert (((VirtualLeafBytes)mutation.value).keyBytes().equals((Object)leaf.keyBytes()));
            sizeDelta -= (long)((VirtualLeafBytes)mutation.value).getSizeInBytes();
            mutation.value = leaf;
            mutation.setDeleted(false);
            sizeDelta += (long)((VirtualLeafBytes)mutation.value).getSizeInBytes();
        } else {
            mutation.setDeleted(false);
        }
        this.estimatedLeavesSizeInBytes.addAndGet(sizeDelta);
        return mutation;
    }

    private static <K, V> void purge(ConcurrentArray<Mutation<K, V>> array, Map<K, Mutation<K, V>> index, @NonNull VirtualMapConfig virtualMapConfig) {
        array.parallelTraverse(VirtualNodeCache.getCleaningPool(virtualMapConfig), element -> {
            if (element.notFiltered()) {
                index.compute(element.key, (key, mutation) -> {
                    if (mutation == null || element.equals(mutation)) {
                        return null;
                    }
                    Mutation m = mutation;
                    while (m.next != null) {
                        if (element.equals(m.next)) {
                            m.next = null;
                            break;
                        }
                        m = m.next;
                    }
                    return mutation;
                });
            }
        });
    }

    private static <K, V> void filterMutations(ConcurrentArray<Mutation<K, V>> array, @NonNull VirtualMapConfig virtualMapConfig) {
        Consumer<Mutation> action = mutation -> {
            Mutation nextMutation = mutation.next;
            if (nextMutation != null) {
                nextMutation.setFiltered();
            }
        };
        try {
            array.parallelTraverse(VirtualNodeCache.getCleaningPool(virtualMapConfig), action).getAndRethrow();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private <K, L> void setMapSnapshotAndArray(Map<K, Mutation<K, L>> src, Map<K, Mutation<K, L>> dst, ConcurrentArray<Mutation<K, L>> array) {
        long accepted = this.fastCopyVersion.get();
        long rejected = this.lastReleased.get();
        for (Map.Entry<K, Mutation<K, L>> entry : src.entrySet()) {
            Mutation<K, Object> mutation = entry.getValue();
            while (mutation != null && mutation.version > accepted) {
                mutation = mutation.next;
            }
            if (mutation == null || mutation.version <= rejected) continue;
            dst.put(entry.getKey(), mutation);
            array.add(mutation);
        }
    }

    private void serializePathToDirtyHashIndex(Map<Long, Mutation<Long, Hash>> map, SerializableDataOutputStream out) throws IOException {
        assert (this.snapshot.get()) : "Only snapshots can be serialized";
        out.writeInt(map.size());
        for (Map.Entry<Long, Mutation<Long, Hash>> entry : map.entrySet()) {
            out.writeLong(entry.getKey().longValue());
            Mutation<Long, Hash> mutation = entry.getValue();
            assert (mutation != null) : "Mutations cannot be null in a snapshot";
            assert (mutation.version <= this.fastCopyVersion.get()) : "Trying to serialize pathToDirtyInternalIndex with a version ahead";
            out.writeLong(mutation.version);
            out.writeBoolean(mutation.isDeleted());
            if (mutation.isDeleted()) continue;
            out.writeSerializable((SelfSerializable)mutation.value, true);
        }
    }

    private void deserializePathToDirtyHashIndex(Map<Long, Mutation<Long, Hash>> map, SerializableDataInputStream in, int version) throws IOException {
        int sizeOfMap = in.readInt();
        for (int index = 0; index < sizeOfMap; ++index) {
            long key = in.readLong();
            long mutationVersion = in.readLong();
            boolean isDeleted = in.readBoolean();
            Hash hash = null;
            if (!isDeleted) {
                if (version == 1) {
                    in.readLong();
                }
                hash = (Hash)in.readSerializable();
            }
            Mutation<Long, Hash> mutation = new Mutation<Long, Hash>(null, key, hash, mutationVersion);
            mutation.setDeleted(isDeleted);
            map.put(key, mutation);
            this.dirtyHashes.add(mutation);
        }
    }

    private void serializePathToDirtyLeafIndex(Map<Long, Mutation<Long, Bytes>> map, SerializableDataOutputStream out) throws IOException {
        assert (this.snapshot.get()) : "Only snapshots can be serialized";
        out.writeInt(map.size());
        for (Map.Entry<Long, Mutation<Long, Bytes>> entry : map.entrySet()) {
            out.writeLong(entry.getKey().longValue());
            Mutation<Long, Bytes> mutation = entry.getValue();
            assert (mutation != null) : "Mutations cannot be null in a snapshot";
            assert (mutation.version <= this.fastCopyVersion.get()) : "Trying to serialize pathToDirtyLeafIndex with a version ahead";
            if (mutation.value == null) {
                out.writeInt(-1);
            } else {
                out.writeInt(Math.toIntExact(((Bytes)mutation.value).length()));
                ((Bytes)mutation.value).writeTo((OutputStream)out);
            }
            out.writeLong(mutation.version);
            out.writeBoolean(mutation.isDeleted());
        }
    }

    private void deserializePathToDirtyLeafIndex(Map<Long, Mutation<Long, Bytes>> map, SerializableDataInputStream in) throws IOException {
        int sizeOfMap = in.readInt();
        for (int index = 0; index < sizeOfMap; ++index) {
            Long path = in.readLong();
            int keyLen = in.readInt();
            Bytes key = keyLen < 0 ? null : (keyLen == 0 ? Bytes.EMPTY : Bytes.wrap((byte[])in.readNBytes(keyLen)));
            long mutationVersion = in.readLong();
            boolean deleted = in.readBoolean();
            Mutation<Long, Bytes> mutation = new Mutation<Long, Bytes>(null, path, key, mutationVersion);
            mutation.setDeleted(deleted);
            map.put(path, mutation);
            this.dirtyLeafPaths.add(mutation);
        }
    }

    private void serializeKeyToDirtyLeafIndex(Map<Bytes, Mutation<Bytes, VirtualLeafBytes>> map, SerializableDataOutputStream out) throws IOException {
        assert (this.snapshot.get()) : "Only snapshots can be serialized";
        out.writeInt(map.size());
        for (Map.Entry<Bytes, Mutation<Bytes, VirtualLeafBytes>> entry : map.entrySet()) {
            Mutation<Bytes, VirtualLeafBytes> mutation = entry.getValue();
            assert (mutation != null) : "Mutations cannot be null in a snapshot";
            assert (mutation.version <= this.fastCopyVersion.get()) : "Trying to serialize keyToDirtyLeafIndex with a version ahead";
            VirtualLeafBytes leaf = (VirtualLeafBytes)mutation.value;
            out.writeLong(leaf.path());
            out.writeInt(Math.toIntExact(leaf.keyBytes().length()));
            leaf.keyBytes().writeTo((OutputStream)out);
            Bytes value = leaf.valueBytes();
            if (value == null) {
                out.writeInt(0);
            } else {
                out.writeInt(Math.toIntExact(value.length()));
                value.writeTo((OutputStream)out);
            }
            out.writeLong(mutation.version);
            out.writeBoolean(mutation.isDeleted());
        }
    }

    private void deserializeKeyToDirtyLeafIndex(Map<Bytes, Mutation<Bytes, VirtualLeafBytes>> map, SerializableDataInputStream in, int version) throws IOException {
        int sizeOfMap = in.readInt();
        for (int index = 0; index < sizeOfMap; ++index) {
            long path = in.readLong();
            int keyLen = in.readInt();
            Bytes key = Bytes.wrap((byte[])in.readNBytes(keyLen));
            int valueLen = in.readInt();
            Bytes value = valueLen == 0 ? null : Bytes.wrap((byte[])in.readNBytes(valueLen));
            VirtualLeafBytes leafRecord = new VirtualLeafBytes(path, key, value);
            long mutationVersion = in.readLong();
            boolean deleted = in.readBoolean();
            Mutation mutation = new Mutation(null, key, leafRecord, mutationVersion);
            mutation.setDeleted(deleted);
            map.put(key, mutation);
            this.dirtyLeaves.add(mutation);
        }
    }

    public long getEstimatedSize() {
        return this.estimatedLeavesSizeInBytes.get() + this.estimatedLeafPathsSizeInBytes.get() + this.estimatedHashesSizeInBytes.get();
    }

    private void throwIfLeafImmutable() {
        if (this.leafIndexesAreImmutable.get()) {
            throw new MutabilityException("This operation is not permitted on immutable leaves");
        }
    }

    private void throwIfInternalsImmutable() {
        if (this.hashesAreImmutable.get()) {
            throw new MutabilityException("This operation is not permitted on immutable internals");
        }
    }

    public String toDebugString() {
        StringBuilder builder = new StringBuilder();
        builder.append("VirtualNodeCache ").append(this).append("\n");
        builder.append("===================================\n");
        builder.append(this.toDebugStringChain()).append("\n");
        builder.append(this.toDebugStringIndex("keyToDirtyLeafIndex", this.keyToDirtyLeafIndex)).append("\n");
        builder.append(this.toDebugStringIndex("pathToDirtyLeafIndex", this.pathToDirtyLeafIndex)).append("\n");
        builder.append(this.toDebugStringIndex("pathToDirtyHashIndex", this.pathToDirtyHashIndex)).append("\n");
        builder.append(this.toDebugStringArray("dirtyLeaves", this.dirtyLeaves));
        builder.append(this.toDebugStringArray("dirtyLeafPaths", this.dirtyLeafPaths));
        builder.append(this.toDebugStringArray("dirtyHashes", this.dirtyHashes));
        return builder.toString();
    }

    private String toDebugStringChain() {
        VirtualNodeCache prevCache;
        StringBuilder builder = new StringBuilder();
        builder.append("Copies:\n");
        builder.append("\t");
        VirtualNodeCache firstCache = this;
        while ((prevCache = firstCache.prev.get()) != null) {
            firstCache = prevCache;
        }
        while (firstCache != null) {
            builder.append("[").append(firstCache.fastCopyVersion.get()).append(firstCache == this ? "*" : "").append("]->");
            firstCache = firstCache.next.get();
        }
        return builder.toString();
    }

    private String toDebugStringIndex(String indexName, Map<Object, Mutation> index) {
        StringBuilder builder = new StringBuilder();
        builder.append(indexName).append(":\n");
        index.forEach((key, mutation) -> {
            builder.append("\t").append(key).append(":==> ");
            while (mutation != null) {
                builder.append("[").append(mutation.key).append(",").append(mutation.value).append(",").append(mutation.isDeleted() ? "D," : "").append("V").append(mutation.version).append(mutation.version == this.fastCopyVersion.get() ? "*" : "").append("]->");
                mutation = mutation.next;
            }
            builder.append("\n");
        });
        return builder.toString();
    }

    private String toDebugStringArray(String name, ConcurrentArray<Mutation> arr) {
        StringBuilder builder = new StringBuilder();
        builder.append(name).append(":\n");
        int size = arr.size();
        for (int i = 0; i < size; ++i) {
            Mutation mutation = arr.get(i);
            builder.append("\t").append(mutation.key).append(",").append(mutation.value).append(",").append(mutation.isDeleted() ? "D," : "").append("V").append(mutation.version).append(mutation.version == this.fastCopyVersion.get() ? "*" : "").append("]\n");
        }
        return builder.toString();
    }

    private static final class Mutation<K, V> {
        private volatile Mutation<K, V> next;
        private final long version;
        private final K key;
        private volatile V value;
        private volatile byte flags = 0;
        private static final int FLAG_BIT_DELETED = 0;
        private static final int FLAG_BIT_FILTERED = 1;

        Mutation(Mutation<K, V> next, K key, V value, long version) {
            this.next = next;
            this.key = key;
            this.value = value;
            this.version = version;
        }

        static boolean getFlag(byte flags, int bit) {
            return (0xFF & flags & 1 << bit) != 0;
        }

        void setFlag(int bit, boolean value) {
            this.flags = value ? (byte)(this.flags | 1 << bit) : (byte)(this.flags & ~(1 << bit));
        }

        boolean isDeleted() {
            return Mutation.getFlag(this.flags, 0);
        }

        void setDeleted(boolean deleted) {
            this.setFlag(0, deleted);
        }

        boolean notFiltered() {
            return !Mutation.getFlag(this.flags, 1);
        }

        void setFiltered() {
            this.setFlag(1, true);
        }
    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;
        public static final int NO_LEAF_HASHES = 2;

        private ClassVersion() {
        }
    }
}

