/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.token.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.NftID;
import com.hedera.hapi.node.base.PendingAirdropId;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.AccountApprovalForAllAllowance;
import com.hedera.hapi.node.state.token.AccountCryptoAllowance;
import com.hedera.hapi.node.state.token.AccountFungibleTokenAllowance;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class AccountJsonCodec
implements JsonCodec<Account> {
    public static final OneOf<Account.StakedIdOneOfType> STAKED_ID_UNSET = new OneOf((Enum)Account.StakedIdOneOfType.UNSET, null);

    @NonNull
    public Account parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            AccountID temp_account_id = null;
            Bytes temp_alias = Bytes.EMPTY;
            Key temp_key = null;
            long temp_expiration_second = 0L;
            long temp_tinybar_balance = 0L;
            String temp_memo = "";
            boolean temp_deleted = false;
            long temp_staked_to_me = 0L;
            long temp_stake_period_start = 0L;
            OneOf temp_staked_id = STAKED_ID_UNSET;
            boolean temp_decline_reward = false;
            boolean temp_receiver_sig_required = false;
            TokenID temp_head_token_id = null;
            NftID temp_head_nft_id = null;
            long temp_head_nft_serial_number = 0L;
            long temp_number_owned_nfts = 0L;
            int temp_max_auto_associations = 0;
            int temp_used_auto_associations = 0;
            int temp_number_associations = 0;
            boolean temp_smart_contract = false;
            int temp_number_positive_balances = 0;
            long temp_ethereum_nonce = 0L;
            long temp_stake_at_start_of_last_rewarded_period = 0L;
            AccountID temp_auto_renew_account_id = null;
            long temp_auto_renew_seconds = 0L;
            int temp_contract_kv_pairs_number = 0;
            List temp_crypto_allowances = Collections.emptyList();
            List temp_approve_for_all_nft_allowances = Collections.emptyList();
            List temp_token_allowances = Collections.emptyList();
            int temp_number_treasury_titles = 0;
            boolean temp_expired_and_pending_removal = false;
            Bytes temp_first_contract_storage_key = Bytes.EMPTY;
            PendingAirdropId temp_head_pending_airdrop_id = null;
            long temp_number_pending_airdrops = 0L;
            long temp_number_hooks_in_use = 0L;
            long temp_first_hook_id = 0L;
            long temp_number_lambda_storage_slots = 0L;
            block82: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "accountId": {
                        temp_account_id = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block82;
                    }
                    case "alias": {
                        temp_alias = Bytes.fromBase64((String)JsonTools.checkSize((String)"alias", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block82;
                    }
                    case "key": {
                        temp_key = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block82;
                    }
                    case "expirationSecond": {
                        temp_expiration_second = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block82;
                    }
                    case "tinybarBalance": {
                        temp_tinybar_balance = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block82;
                    }
                    case "memo": {
                        temp_memo = JsonTools.unescape((String)JsonTools.checkSize((String)"memo", (String)kvPair.value().STRING().getText(), (int)maxSize));
                        continue block82;
                    }
                    case "deleted": {
                        temp_deleted = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                        continue block82;
                    }
                    case "stakedToMe": {
                        temp_staked_to_me = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block82;
                    }
                    case "stakePeriodStart": {
                        temp_stake_period_start = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block82;
                    }
                    case "stakedAccountId": {
                        temp_staked_id = new OneOf((Enum)Account.StakedIdOneOfType.STAKED_ACCOUNT_ID, AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize));
                        continue block82;
                    }
                    case "stakedNodeId": {
                        temp_staked_id = new OneOf((Enum)Account.StakedIdOneOfType.STAKED_NODE_ID, (Object)JsonTools.parseLong((JSONParser.ValueContext)kvPair.value()));
                        continue block82;
                    }
                    case "declineReward": {
                        temp_decline_reward = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                        continue block82;
                    }
                    case "receiverSigRequired": {
                        temp_receiver_sig_required = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                        continue block82;
                    }
                    case "headTokenId": {
                        temp_head_token_id = (TokenID)TokenID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block82;
                    }
                    case "headNftId": {
                        temp_head_nft_id = (NftID)NftID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block82;
                    }
                    case "headNftSerialNumber": {
                        temp_head_nft_serial_number = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block82;
                    }
                    case "numberOwnedNfts": {
                        temp_number_owned_nfts = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block82;
                    }
                    case "maxAutoAssociations": {
                        temp_max_auto_associations = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                        continue block82;
                    }
                    case "usedAutoAssociations": {
                        temp_used_auto_associations = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                        continue block82;
                    }
                    case "numberAssociations": {
                        temp_number_associations = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                        continue block82;
                    }
                    case "smartContract": {
                        temp_smart_contract = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                        continue block82;
                    }
                    case "numberPositiveBalances": {
                        temp_number_positive_balances = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                        continue block82;
                    }
                    case "ethereumNonce": {
                        temp_ethereum_nonce = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block82;
                    }
                    case "stakeAtStartOfLastRewardedPeriod": {
                        temp_stake_at_start_of_last_rewarded_period = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block82;
                    }
                    case "autoRenewAccountId": {
                        temp_auto_renew_account_id = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block82;
                    }
                    case "autoRenewSeconds": {
                        temp_auto_renew_seconds = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block82;
                    }
                    case "contractKvPairsNumber": {
                        temp_contract_kv_pairs_number = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                        continue block82;
                    }
                    case "cryptoAllowances": {
                        temp_crypto_allowances = JsonTools.parseObjArray((List)JsonTools.checkSize((String)"crypto_allowances", (List)kvPair.value().arr().value(), (int)maxSize), AccountCryptoAllowance.JSON, (int)(maxDepth - 1), (int)maxSize);
                        continue block82;
                    }
                    case "approveForAllNftAllowances": {
                        temp_approve_for_all_nft_allowances = JsonTools.parseObjArray((List)JsonTools.checkSize((String)"approve_for_all_nft_allowances", (List)kvPair.value().arr().value(), (int)maxSize), AccountApprovalForAllAllowance.JSON, (int)(maxDepth - 1), (int)maxSize);
                        continue block82;
                    }
                    case "tokenAllowances": {
                        temp_token_allowances = JsonTools.parseObjArray((List)JsonTools.checkSize((String)"token_allowances", (List)kvPair.value().arr().value(), (int)maxSize), AccountFungibleTokenAllowance.JSON, (int)(maxDepth - 1), (int)maxSize);
                        continue block82;
                    }
                    case "numberTreasuryTitles": {
                        temp_number_treasury_titles = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                        continue block82;
                    }
                    case "expiredAndPendingRemoval": {
                        temp_expired_and_pending_removal = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                        continue block82;
                    }
                    case "firstContractStorageKey": {
                        temp_first_contract_storage_key = Bytes.fromBase64((String)JsonTools.checkSize((String)"first_contract_storage_key", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block82;
                    }
                    case "headPendingAirdropId": {
                        temp_head_pending_airdrop_id = (PendingAirdropId)PendingAirdropId.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block82;
                    }
                    case "numberPendingAirdrops": {
                        temp_number_pending_airdrops = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block82;
                    }
                    case "numberHooksInUse": {
                        temp_number_hooks_in_use = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block82;
                    }
                    case "firstHookId": {
                        temp_first_hook_id = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block82;
                    }
                    case "numberLambdaStorageSlots": {
                        temp_number_lambda_storage_slots = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block82;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new Account(temp_account_id, temp_alias, temp_key, temp_expiration_second, temp_tinybar_balance, temp_memo, temp_deleted, temp_staked_to_me, temp_stake_period_start, (OneOf<Account.StakedIdOneOfType>)temp_staked_id, temp_decline_reward, temp_receiver_sig_required, temp_head_token_id, temp_head_nft_id, temp_head_nft_serial_number, temp_number_owned_nfts, temp_max_auto_associations, temp_used_auto_associations, temp_number_associations, temp_smart_contract, temp_number_positive_balances, temp_ethereum_nonce, temp_stake_at_start_of_last_rewarded_period, temp_auto_renew_account_id, temp_auto_renew_seconds, temp_contract_kv_pairs_number, temp_crypto_allowances, temp_approve_for_all_nft_allowances, temp_token_allowances, temp_number_treasury_titles, temp_expired_and_pending_removal, temp_first_contract_storage_key, temp_head_pending_airdrop_id, temp_number_pending_airdrops, temp_number_hooks_in_use, temp_first_hook_id, temp_number_lambda_storage_slots);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull Account data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.accountId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"accountId", AccountID.JSON, (Object)data.accountId()));
        }
        if (data.alias() != Bytes.EMPTY && data.alias() != null && data.alias().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"alias", (Bytes)data.alias()));
        }
        if (data.key() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"key", Key.JSON, (Object)data.key()));
        }
        if (data.expirationSecond() != 0L) {
            fieldLines.add(JsonTools.field((String)"expirationSecond", (long)data.expirationSecond()));
        }
        if (data.tinybarBalance() != 0L) {
            fieldLines.add(JsonTools.field((String)"tinybarBalance", (long)data.tinybarBalance()));
        }
        if (data.memo() != null && !data.memo().isEmpty()) {
            fieldLines.add(JsonTools.field((String)"memo", (String)data.memo()));
        }
        if (data.deleted()) {
            fieldLines.add(JsonTools.field((String)"deleted", (boolean)data.deleted()));
        }
        if (data.stakedToMe() != 0L) {
            fieldLines.add(JsonTools.field((String)"stakedToMe", (long)data.stakedToMe()));
        }
        if (data.stakePeriodStart() != 0L) {
            fieldLines.add(JsonTools.field((String)"stakePeriodStart", (long)data.stakePeriodStart()));
        }
        if (data.stakedId().kind() == Account.StakedIdOneOfType.STAKED_ACCOUNT_ID) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"stakedAccountId", AccountID.JSON, (Object)data.stakedAccountId()));
        }
        if (data.stakedId().kind() == Account.StakedIdOneOfType.STAKED_NODE_ID) {
            fieldLines.add(JsonTools.field((String)"stakedNodeId", (long)data.stakedNodeId()));
        }
        if (data.declineReward()) {
            fieldLines.add(JsonTools.field((String)"declineReward", (boolean)data.declineReward()));
        }
        if (data.receiverSigRequired()) {
            fieldLines.add(JsonTools.field((String)"receiverSigRequired", (boolean)data.receiverSigRequired()));
        }
        if (data.headTokenId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"headTokenId", TokenID.JSON, (Object)data.headTokenId()));
        }
        if (data.headNftId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"headNftId", NftID.JSON, (Object)data.headNftId()));
        }
        if (data.headNftSerialNumber() != 0L) {
            fieldLines.add(JsonTools.field((String)"headNftSerialNumber", (long)data.headNftSerialNumber()));
        }
        if (data.numberOwnedNfts() != 0L) {
            fieldLines.add(JsonTools.field((String)"numberOwnedNfts", (long)data.numberOwnedNfts()));
        }
        if (data.maxAutoAssociations() != 0) {
            fieldLines.add(JsonTools.field((String)"maxAutoAssociations", (int)data.maxAutoAssociations()));
        }
        if (data.usedAutoAssociations() != 0) {
            fieldLines.add(JsonTools.field((String)"usedAutoAssociations", (int)data.usedAutoAssociations()));
        }
        if (data.numberAssociations() != 0) {
            fieldLines.add(JsonTools.field((String)"numberAssociations", (int)data.numberAssociations()));
        }
        if (data.smartContract()) {
            fieldLines.add(JsonTools.field((String)"smartContract", (boolean)data.smartContract()));
        }
        if (data.numberPositiveBalances() != 0) {
            fieldLines.add(JsonTools.field((String)"numberPositiveBalances", (int)data.numberPositiveBalances()));
        }
        if (data.ethereumNonce() != 0L) {
            fieldLines.add(JsonTools.field((String)"ethereumNonce", (long)data.ethereumNonce()));
        }
        if (data.stakeAtStartOfLastRewardedPeriod() != 0L) {
            fieldLines.add(JsonTools.field((String)"stakeAtStartOfLastRewardedPeriod", (long)data.stakeAtStartOfLastRewardedPeriod()));
        }
        if (data.autoRenewAccountId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"autoRenewAccountId", AccountID.JSON, (Object)data.autoRenewAccountId()));
        }
        if (data.autoRenewSeconds() != 0L) {
            fieldLines.add(JsonTools.field((String)"autoRenewSeconds", (long)data.autoRenewSeconds()));
        }
        if (data.contractKvPairsNumber() != 0) {
            fieldLines.add(JsonTools.field((String)"contractKvPairsNumber", (int)data.contractKvPairsNumber()));
        }
        if (!data.cryptoAllowances().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"cryptoAllowances", AccountCryptoAllowance.JSON, data.cryptoAllowances()));
        }
        if (!data.approveForAllNftAllowances().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"approveForAllNftAllowances", AccountApprovalForAllAllowance.JSON, data.approveForAllNftAllowances()));
        }
        if (!data.tokenAllowances().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"tokenAllowances", AccountFungibleTokenAllowance.JSON, data.tokenAllowances()));
        }
        if (data.numberTreasuryTitles() != 0) {
            fieldLines.add(JsonTools.field((String)"numberTreasuryTitles", (int)data.numberTreasuryTitles()));
        }
        if (data.expiredAndPendingRemoval()) {
            fieldLines.add(JsonTools.field((String)"expiredAndPendingRemoval", (boolean)data.expiredAndPendingRemoval()));
        }
        if (data.firstContractStorageKey() != Bytes.EMPTY && data.firstContractStorageKey() != null && data.firstContractStorageKey().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"firstContractStorageKey", (Bytes)data.firstContractStorageKey()));
        }
        if (data.headPendingAirdropId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"headPendingAirdropId", PendingAirdropId.JSON, (Object)data.headPendingAirdropId()));
        }
        if (data.numberPendingAirdrops() != 0L) {
            fieldLines.add(JsonTools.field((String)"numberPendingAirdrops", (long)data.numberPendingAirdrops()));
        }
        if (data.numberHooksInUse() != 0L) {
            fieldLines.add(JsonTools.field((String)"numberHooksInUse", (long)data.numberHooksInUse()));
        }
        if (data.firstHookId() != 0L) {
            fieldLines.add(JsonTools.field((String)"firstHookId", (long)data.firstHookId()));
        }
        if (data.numberLambdaStorageSlots() != 0L) {
            fieldLines.add(JsonTools.field((String)"numberLambdaStorageSlots", (long)data.numberLambdaStorageSlots()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

