/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb.utilities;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public final class MerkleDbFileUtils {
    private MerkleDbFileUtils() {
    }

    public static int completelyRead(ReadableByteChannel fileChannel, ByteBuffer dstBuffer) throws IOException {
        int bytesRead;
        int totalBytesRead = 0;
        while (dstBuffer.hasRemaining() && (bytesRead = fileChannel.read(dstBuffer)) >= 0) {
            totalBytesRead += bytesRead;
        }
        return totalBytesRead;
    }

    public static ByteBuffer readFromFileChannel(FileChannel fileChannel, int bytesToRead) throws IOException {
        ByteBuffer headerBuffer = ByteBuffer.allocate(bytesToRead);
        if (MerkleDbFileUtils.completelyRead(fileChannel, headerBuffer) != bytesToRead) {
            throw new IOException("Failed to read " + bytesToRead + " bytes from file channel " + String.valueOf(fileChannel));
        }
        headerBuffer.rewind();
        return headerBuffer;
    }

    public static int completelyRead(FileChannel fileChannel, ByteBuffer dstBuffer, long startPosition) throws IOException {
        int bytesRead;
        int totalBytesRead = 0;
        while (dstBuffer.hasRemaining() && (bytesRead = fileChannel.read(dstBuffer, startPosition + (long)totalBytesRead)) >= 0) {
            totalBytesRead += bytesRead;
        }
        return totalBytesRead;
    }

    public static int completelyWrite(WritableByteChannel fileChannel, ByteBuffer srcBuffer) throws IOException {
        int totalBytesWritten = 0;
        while (srcBuffer.hasRemaining()) {
            totalBytesWritten += fileChannel.write(srcBuffer);
        }
        return totalBytesWritten;
    }

    public static int completelyWrite(FileChannel fileChannel, ByteBuffer srcBuffer, long startPosition) throws IOException {
        int totalBytesWritten = 0;
        while (srcBuffer.hasRemaining()) {
            totalBytesWritten += fileChannel.write(srcBuffer, startPosition + (long)totalBytesWritten);
        }
        return totalBytesWritten;
    }

    public static long completelyTransferFrom(FileChannel dstChannel, ReadableByteChannel srcChannel, long dstPosition, long maxBytesToTransfer) throws IOException {
        long totalBytesTransferred;
        long bytesTransferred;
        for (totalBytesTransferred = 0L; totalBytesTransferred < maxBytesToTransfer && (bytesTransferred = dstChannel.transferFrom(srcChannel, dstPosition + totalBytesTransferred, maxBytesToTransfer - totalBytesTransferred)) > 0L; totalBytesTransferred += bytesTransferred) {
        }
        return totalBytesTransferred;
    }
}

