/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.crypto.engine;

import com.swirlds.logging.legacy.LogMarker;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.DigestType;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.HashBuilder;
import org.hiero.base.crypto.engine.CachingOperationProvider;

public class RunningHashProvider
extends CachingOperationProvider<Hash, Hash, Hash, HashBuilder, DigestType> {
    private static final Logger logger = LogManager.getLogger(RunningHashProvider.class);
    private static final String NEW_HASH_NULL = "RunningHashProvider :: newHashToAdd is null";

    private static void updateForHash(HashBuilder hashBuilder, Hash hash) {
        hashBuilder.update(hash.getClassId());
        hashBuilder.update(hash.getVersion());
        hashBuilder.update(hash);
    }

    @Override
    protected HashBuilder handleAlgorithmRequired(DigestType algorithmType) throws NoSuchAlgorithmException {
        return new HashBuilder(MessageDigest.getInstance(algorithmType.algorithmName()));
    }

    @Override
    protected Hash handleItem(HashBuilder hashBuilder, DigestType algorithmType, Hash runningHash, Hash newHashToAdd) {
        if (newHashToAdd == null) {
            logger.trace(LogMarker.TESTING_EXCEPTIONS.getMarker(), NEW_HASH_NULL);
            throw new IllegalArgumentException(NEW_HASH_NULL);
        }
        hashBuilder.reset();
        if (runningHash != null) {
            RunningHashProvider.updateForHash(hashBuilder, runningHash);
        }
        RunningHashProvider.updateForHash(hashBuilder, newHashToAdd);
        return hashBuilder.build();
    }

    @Override
    public Hash compute(Hash runningHash, Hash newHashToAdd, DigestType algorithmType) throws NoSuchAlgorithmException {
        return this.handleItem((HashBuilder)this.loadAlgorithm(algorithmType), algorithmType, runningHash, newHashToAdd);
    }
}

