/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.platform;

import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.logging.legacy.payload.SyntheticBottleneckFinishPayload;
import com.swirlds.logging.legacy.payload.SyntheticBottleneckStartPayload;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SyntheticBottleneckConfig {
    private static final Logger logger = LogManager.getLogger(SyntheticBottleneckConfig.class);
    private final Set<Long> targetNodeIds = new HashSet<Long>();
    private int reconnectCount;
    private int maximumReconnectCount = 0;
    private long millisecondsSlept;
    private long millisecondSleepPeriod = 1000L;
    private long totalMillisecondsToSleep = 120000L;
    private long throttleInitMillisecondDelay = 120000L;
    private long throttleInitTimestamp = System.currentTimeMillis();
    private static SyntheticBottleneckConfig activeConfig;
    private static final SyntheticBottleneckConfig defaultConfig;

    public static synchronized SyntheticBottleneckConfig getActiveConfig() {
        return activeConfig != null ? activeConfig : defaultConfig;
    }

    public static synchronized void setActiveConfig(SyntheticBottleneckConfig activeConfig) {
        SyntheticBottleneckConfig.activeConfig = activeConfig;
    }

    public synchronized void registerReconnect(long nodeId) {
        if (!this.targetNodeIds.contains(nodeId)) {
            return;
        }
        ++this.reconnectCount;
        this.millisecondsSlept = 0L;
        logger.info(LogMarker.DEMO_INFO.getMarker(), "{}", (Object)new SyntheticBottleneckFinishPayload("finishing synthetic node throttle"));
        this.throttleInitTimestamp = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void throttleIfNeeded(long nodeId) {
        SyntheticBottleneckConfig syntheticBottleneckConfig = this;
        synchronized (syntheticBottleneckConfig) {
            if (!this.targetNodeIds.contains(nodeId)) {
                return;
            }
            if (this.millisecondsSlept > this.totalMillisecondsToSleep) {
                return;
            }
            if (this.reconnectCount >= this.maximumReconnectCount) {
                return;
            }
            if (System.currentTimeMillis() - this.throttleInitTimestamp < this.throttleInitMillisecondDelay) {
                return;
            }
            if (this.millisecondsSlept == 0L) {
                logger.info(LogMarker.DEMO_INFO.getMarker(), "{}", (Object)new SyntheticBottleneckStartPayload("engaging synthetic node throttle"));
            }
            this.millisecondsSlept += this.millisecondSleepPeriod;
        }
        try {
            logger.info(LogMarker.DEMO_INFO.getMarker(), "Will sleep for {}ms on throttle", (Object)this.millisecondSleepPeriod);
            Thread.sleep(this.millisecondSleepPeriod);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public Set<Long> getTargetNodeIds() {
        return this.targetNodeIds;
    }

    public void setTargetNodeIds(Set<Long> targetNodeIds) {
        this.targetNodeIds.clear();
        this.targetNodeIds.addAll(targetNodeIds);
    }

    public int getMaximumReconnectCount() {
        return this.maximumReconnectCount;
    }

    public void setMaximumReconnectCount(int maximumReconnectCount) {
        this.maximumReconnectCount = maximumReconnectCount;
    }

    public long getMillisecondSleepPeriod() {
        return this.millisecondSleepPeriod;
    }

    public void setMillisecondSleepPeriod(long millisecondSleepPeriod) {
        this.millisecondSleepPeriod = millisecondSleepPeriod;
    }

    public long getTotalMillisecondsToSleep() {
        return this.totalMillisecondsToSleep;
    }

    public void setTotalMillisecondsToSleep(long totalMillisecondsToSleep) {
        this.totalMillisecondsToSleep = totalMillisecondsToSleep;
    }

    public long getThrottleInitMillisecondDelay() {
        return this.throttleInitMillisecondDelay;
    }

    public void setThrottleInitMillisecondDelay(long throttleInitMillisecondDelay) {
        this.throttleInitMillisecondDelay = throttleInitMillisecondDelay;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("target: ").append(this.targetNodeIds).append(", total reconnects: ").append(this.maximumReconnectCount);
        return sb.toString();
    }

    static {
        defaultConfig = new SyntheticBottleneckConfig();
    }
}

