/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.virtualmerkle.map.smartcontracts.data;

import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.swirlds.demo.virtualmerkle.random.PTTRandom;
import com.swirlds.virtualmap.VirtualValue;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public final class SmartContractMapValue
implements VirtualValue {
    private static final long CLASS_ID = -1338661870551442912L;
    private byte[] value;

    public SmartContractMapValue() {
        this.value = new byte[this.getSizeInBytes()];
    }

    public SmartContractMapValue(PTTRandom random) {
        this.value = new byte[this.getSizeInBytes()];
        this.changeValue(random);
    }

    public SmartContractMapValue(SmartContractMapValue source) {
        this.value = source.getValue();
    }

    public SmartContractMapValue(byte[] value) {
        if (value.length != this.getSizeInBytes()) {
            throw new IllegalArgumentException("Invalid value for smart contract");
        }
        this.value = Arrays.copyOf(value, this.getSizeInBytes());
    }

    public SmartContractMapValue(ReadableSequentialData in) {
        int len = in.readInt();
        this.value = new byte[len];
        in.readBytes(this.value);
    }

    public SmartContractMapValue(long value) {
        this.value = ByteBuffer.allocate(this.getSizeInBytes()).putLong(value).array();
    }

    public void writeTo(WritableSequentialData out) {
        out.writeInt(this.value.length);
        out.writeBytes(this.value);
    }

    public long getClassId() {
        return -1338661870551442912L;
    }

    public int getVersion() {
        return 1;
    }

    public SmartContractMapValue copy() {
        return new SmartContractMapValue(this);
    }

    public SmartContractMapValue asReadOnly() {
        return new SmartContractMapValue(this);
    }

    public String toString() {
        return "SmartContractMapValue{value=" + String.valueOf(this.value) + "}";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SmartContractMapValue that = (SmartContractMapValue)other;
        return Arrays.equals(this.value, that.value);
    }

    public byte[] getValue() {
        return Arrays.copyOf(this.value, this.value.length);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public int getSizeInBytes() {
        return 32;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.write(this.value);
    }

    void serialize(WritableSequentialData out) {
        out.writeBytes(this.value);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.value = new byte[this.getSizeInBytes()];
        if (in.read(this.value) != this.getSizeInBytes()) {
            throw new IOException("Failed to read the correct number of bytes!");
        }
    }

    void deserialize(ReadableSequentialData in) {
        in.readBytes(this.value);
    }

    public long getValueAsLong() {
        return ByteBuffer.wrap(this.value).getLong();
    }

    public void changeValue(PTTRandom pttRandom) {
        for (int i = 0; i < this.getSizeInBytes(); ++i) {
            this.value[i] = pttRandom.nextByte();
        }
    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

