/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb.collections;

import com.swirlds.merkledb.collections.LongList;
import java.util.Comparator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.LongConsumer;

final class LongListSpliterator
implements Spliterator.OfLong {
    private final LongList longList;
    private final long fence;
    private long index;

    public LongListSpliterator(LongList longList) {
        this(longList, 0L, longList.size());
    }

    public LongListSpliterator(LongList longList, long origin, long fence) {
        this.longList = longList;
        this.index = origin;
        this.fence = fence;
    }

    @Override
    public Spliterator.OfLong trySplit() {
        long lo = this.index;
        long mid = lo + this.fence >>> 1;
        if (lo >= mid) {
            return null;
        }
        this.index = mid;
        return new LongListSpliterator(this.longList, lo, this.index);
    }

    @Override
    public void forEachRemaining(LongConsumer action) {
        long i;
        Objects.requireNonNull(action);
        LongList a = this.longList;
        long hi = this.fence;
        if (a.size() >= hi && (i = this.index) >= 0L && i < (this.index = hi)) {
            do {
                action.accept(a.get(i, 0L));
            } while (++i < hi);
        }
    }

    @Override
    public boolean tryAdvance(LongConsumer action) {
        Objects.requireNonNull(action);
        if (this.index >= 0L && this.index < this.fence) {
            action.accept(this.longList.get(this.index++, 0L));
            return true;
        }
        return false;
    }

    @Override
    public long estimateSize() {
        return this.fence - this.index;
    }

    @Override
    public int characteristics() {
        return 16448;
    }

    @Override
    public Comparator<? super Long> getComparator() {
        throw new IllegalStateException();
    }
}

