/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.hedera.hapi.platform.event.EventConsensusData;
import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.hedera.hapi.platform.state.JudgeId;
import com.hedera.hapi.util.HapiUtils;
import com.swirlds.base.time.Time;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.utility.Threshold;
import com.swirlds.common.utility.throttle.RateLimitedLogger;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.Consensus;
import com.swirlds.platform.consensus.AncestorSearch;
import com.swirlds.platform.consensus.CandidateWitness;
import com.swirlds.platform.consensus.ConsensusConfig;
import com.swirlds.platform.consensus.ConsensusRounds;
import com.swirlds.platform.consensus.ConsensusSorter;
import com.swirlds.platform.consensus.ConsensusUtils;
import com.swirlds.platform.consensus.CountingVote;
import com.swirlds.platform.consensus.DeGen;
import com.swirlds.platform.consensus.InitJudges;
import com.swirlds.platform.consensus.RoundElections;
import com.swirlds.platform.event.EventUtils;
import com.swirlds.platform.internal.EventImpl;
import com.swirlds.platform.metrics.ConsensusMetrics;
import com.swirlds.platform.util.MarkerFileWriter;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.hiero.base.crypto.Hash;
import org.hiero.base.utility.CommonUtils;
import org.hiero.consensus.model.event.Event;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.ConsensusRound;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.roster.RosterUtils;

public class ConsensusImpl
implements Consensus {
    public static final String COIN_ROUND_MARKER_FILE = "consensus-coin-round";
    public static final String NO_SUPER_MAJORITY_MARKER_FILE = "consensus-no-super-majority";
    public static final String NO_JUDGES_MARKER_FILE = "consensus-no-judges";
    public static final String CONSENSUS_EXCEPTION_MARKER_FILE = "consensus-exception";
    private static final Logger logger = LogManager.getLogger(ConsensusImpl.class);
    private final ConsensusConfig config;
    private final Time time;
    private final Roster roster;
    private final long rosterTotalWeight;
    private final Map<Long, Integer> rosterIndicesMap;
    private final ConsensusMetrics consensusMetrics;
    private final AncestorSearch search = new AncestorSearch();
    private final List<EventImpl> recentEvents = new LinkedList<EventImpl>();
    private final ConsensusRounds rounds;
    private long numConsensus = 0L;
    private Instant lastConsensusTime = null;
    private InitJudges initJudges = null;
    private final MarkerFileWriter markerFileWriter;
    private final RateLimitedLogger noSuperMajorityLogger;
    private final RateLimitedLogger noJudgeLogger;
    private final RateLimitedLogger coinRoundLogger;
    private boolean pcesMode = false;

    public ConsensusImpl(@NonNull PlatformContext platformContext, @NonNull ConsensusMetrics consensusMetrics, @NonNull Roster roster) {
        this.config = (ConsensusConfig)platformContext.getConfiguration().getConfigData(ConsensusConfig.class);
        this.time = platformContext.getTime();
        this.markerFileWriter = new MarkerFileWriter(platformContext);
        this.consensusMetrics = consensusMetrics;
        this.roster = roster;
        this.rosterTotalWeight = RosterUtils.computeTotalWeight((Roster)roster);
        this.rosterIndicesMap = RosterUtils.toIndicesMap((Roster)roster);
        this.rounds = new ConsensusRounds(this.config, roster);
        this.noSuperMajorityLogger = new RateLimitedLogger(logger, platformContext.getTime(), Duration.ofMinutes(1L));
        this.noJudgeLogger = new RateLimitedLogger(logger, platformContext.getTime(), Duration.ofMinutes(1L));
        this.coinRoundLogger = new RateLimitedLogger(logger, platformContext.getTime(), Duration.ofMinutes(1L));
    }

    @Override
    public void loadSnapshot(@NonNull ConsensusSnapshot snapshot) {
        this.reset();
        Set<Hash> judgeHashes = snapshot.judgeIds().stream().map(judge -> new Hash(judge.judgeHash())).collect(Collectors.toSet());
        this.initJudges = new InitJudges(snapshot.round(), judgeHashes);
        this.rounds.loadFromMinimumJudge(snapshot.minimumJudgeInfoList());
        this.numConsensus = snapshot.nextConsensusNumber();
        this.lastConsensusTime = CommonUtils.fromPbjTimestamp((Timestamp)snapshot.consensusTimestamp());
    }

    private void reset() {
        this.recentEvents.clear();
        this.rounds.reset();
        this.numConsensus = 0L;
        this.lastConsensusTime = null;
        this.initJudges = null;
    }

    @Override
    public void setPcesMode(boolean pcesMode) {
        this.pcesMode = pcesMode;
    }

    @Override
    public List<EventImpl> getPreConsensusEvents() {
        return this.recentEvents.stream().filter(e -> !e.isConsensus()).toList();
    }

    @Override
    @NonNull
    public List<ConsensusRound> addEvent(@NonNull EventImpl event) {
        try {
            this.recentEvents.add(event);
            event.setRoundCreated(-1L);
            boolean lastJudgeFound = this.checkInitJudges(event);
            if (this.waitingForInitJudges()) {
                return List.of();
            }
            ConsensusRound consensusRound = lastJudgeFound ? this.recalculateAndVote() : this.calculateAndVote(event);
            ArrayList<ConsensusRound> rounds = new ArrayList<ConsensusRound>();
            while (consensusRound != null) {
                rounds.add(consensusRound);
                consensusRound = this.recalculateAndVote();
            }
            return rounds;
        }
        catch (Exception e) {
            this.markerFileWriter.writeMarkerFile(CONSENSUS_EXCEPTION_MARKER_FILE);
            throw e;
        }
    }

    @Nullable
    private ConsensusRound recalculateAndVote() {
        this.rounds.recalculating();
        Iterator<EventImpl> iterator = this.recentEvents.iterator();
        while (iterator.hasNext()) {
            EventImpl insertedEvent = iterator.next();
            if (this.rounds.isLastDecidedJudge(insertedEvent) && this.round((EventImpl)insertedEvent.getSelfParent()) == 0L && this.round((EventImpl)insertedEvent.getOtherParent()) == 0L) {
                DeGen.calculateDeGen(insertedEvent);
                continue;
            }
            if (insertedEvent.isConsensus() || this.ancient(insertedEvent)) {
                insertedEvent.clearMetadata();
                insertedEvent.setRoundCreated(0L);
                iterator.remove();
                continue;
            }
            insertedEvent.clearMetadata();
            insertedEvent.setRoundCreated(-1L);
            ConsensusRound consensusRound = this.calculateAndVote(insertedEvent);
            if (consensusRound == null) continue;
            return consensusRound;
        }
        return null;
    }

    @Nullable
    private ConsensusRound calculateAndVote(EventImpl event) {
        DeGen.calculateDeGen(event);
        this.round(event);
        this.consensusMetrics.addedEvent(event);
        this.calculateMetadata(event);
        if (!this.witness(event)) {
            return null;
        }
        event.setWitness(true);
        if (this.rounds.getElectionRoundNumber() <= event.getRoundCreated()) {
            if (this.rounds.getElectionRoundNumber() == event.getRoundCreated()) {
                this.rounds.newWitness(event);
            } else {
                this.voteInAllElections(event);
            }
        } else {
            event.setFamous(false);
            event.setFameDecided(true);
        }
        RoundElections roundElections = this.rounds.getElectionRound();
        if (roundElections.isDecided() && !this.waitingForInitJudges()) {
            return this.roundDecided(roundElections);
        }
        return null;
    }

    @Override
    public boolean waitingForInitJudges() {
        return this.initJudges != null && this.initJudges.initJudgesMissing();
    }

    private boolean checkInitJudges(@NonNull EventImpl event) {
        if (!this.waitingForInitJudges()) {
            return false;
        }
        if (!this.initJudges.isInitJudge(event.getBaseHash())) {
            return false;
        }
        this.initJudges.judgeFound(event);
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = this.initJudges::numMissingJudges;
        logger.info(LogMarker.STARTUP.getMarker(), "Found init judge %s, num remaining: {}".formatted(event.shortString()), supplierArray);
        if (this.initJudges.initJudgesMissing()) {
            return false;
        }
        List<EventImpl> ancestors = this.search.commonAncestorsOf(this.initJudges.getJudges(), this::nonConsensusNonAncient);
        ancestors.forEach(e -> {
            e.setConsensus(true);
            e.setRecTimes(null);
        });
        this.rounds.setConsensusRelevantNGen(this.initJudges.getJudges().stream().map(EventImpl::getNGen).min(Long::compareTo).orElse(1L));
        this.initJudges = null;
        return true;
    }

    private void calculateMetadata(@NonNull EventImpl event) {
        if (ConsensusImpl.notRelevantForConsensus(event) || this.rounds.isLastDecidedJudge(event)) {
            return;
        }
        this.lastSee(event, 0L);
        this.timedStronglySeeP(event, 0L);
        this.firstSelfWitnessS(event);
        this.firstWitnessS(event);
    }

    private void voteInAllElections(@NonNull EventImpl votingWitness) {
        RoundElections roundElections = this.rounds.getElectionRound();
        votingWitness.initVoting(roundElections.numElections());
        long diff = this.round(votingWitness) - roundElections.getRound();
        if (diff <= 0L) {
            return;
        }
        if (diff == 1L) {
            Iterator<CandidateWitness> it = roundElections.undecidedWitnesses();
            while (it.hasNext()) {
                CandidateWitness candidateWitness = it.next();
                boolean firstVote = this.firstVote(votingWitness, candidateWitness.getWitness());
                votingWitness.setVote(candidateWitness, firstVote);
                this.logVote(votingWitness, candidateWitness, "first", diff);
            }
            return;
        }
        List<EventImpl> stronglySeen = this.getStronglySeenInPreviousRound(votingWitness);
        Iterator<CandidateWitness> it = roundElections.undecidedWitnesses();
        while (it.hasNext()) {
            CandidateWitness candidateWitness = it.next();
            CountingVote countingVote = this.getCountingVote(candidateWitness, stronglySeen);
            if (this.isCoinRound(diff)) {
                this.coinVote(votingWitness, candidateWitness, countingVote);
                this.logVote(votingWitness, candidateWitness, "coin-" + (countingVote.isSupermajority() ? "counting" : "sig"), diff);
                this.markerFileWriter.writeMarkerFile(COIN_ROUND_MARKER_FILE);
                this.coinRoundLogger.warn(LogMarker.ERROR.getMarker(), "Coin round {}, voting witness: {}", new Object[]{roundElections.getRound(), votingWitness});
                continue;
            }
            votingWitness.setVote(candidateWitness, countingVote.getVote());
            this.logVote(votingWitness, candidateWitness, "counting", diff);
            if (!countingVote.isSupermajority()) continue;
            candidateWitness.fameDecided(votingWitness.getVote(candidateWitness));
            if (!roundElections.isDecided()) continue;
            this.consensusMetrics.lastFamousInRound(candidateWitness.getWitness());
            return;
        }
    }

    @NonNull
    private CountingVote getCountingVote(CandidateWitness candidateWitness, List<EventImpl> stronglySeen) {
        long yesWeight = 0L;
        long noWeight = 0L;
        for (EventImpl w : stronglySeen) {
            long weight = this.getWeight(w.getCreatorId());
            if (w.getVote(candidateWitness)) {
                yesWeight += weight;
                continue;
            }
            noWeight += weight;
        }
        boolean superMajority = Threshold.SUPER_MAJORITY.isSatisfiedBy(yesWeight, this.rosterTotalWeight) || Threshold.SUPER_MAJORITY.isSatisfiedBy(noWeight, this.rosterTotalWeight);
        boolean countingVote = yesWeight >= noWeight;
        return CountingVote.get(countingVote, superMajority);
    }

    private boolean isCoinRound(long diff) {
        return diff % (long)this.config.coinFreq() == 0L;
    }

    private void coinVote(@NonNull EventImpl votingWitness, @NonNull CandidateWitness candidateWitness, @NonNull CountingVote countingVote) {
        this.consensusMetrics.coinRound();
        boolean vote = countingVote.isSupermajority() ? countingVote.getVote() : ConsensusUtils.coin((Event)votingWitness.getBaseEvent());
        votingWitness.setVote(candidateWitness, vote);
    }

    private void logVote(@NonNull EventImpl votingWitness, @NonNull CandidateWitness candidateWitness, @NonNull String votingType, long diff) {
        if (logger.isDebugEnabled(LogMarker.CONSENSUS_VOTING.getMarker())) {
            logger.debug(LogMarker.CONSENSUS_VOTING.getMarker(), "Witness {} voted on {}. vote:{} type:{} diff:{}", (Object)votingWitness.shortString(), (Object)candidateWitness.getWitness().shortString(), (Object)votingWitness.getVote(candidateWitness), (Object)votingType, (Object)diff);
        }
    }

    private boolean firstVote(@NonNull EventImpl voting, @NonNull EventImpl votedOn) {
        EventImpl w = this.firstSee(voting, this.rosterIndicesMap.get(votedOn.getCreatorId().id()).intValue());
        while (w != null && w.getRoundCreated() > voting.getRoundCreated() - 1L && this.selfParent(w) != null) {
            w = this.firstSelfWitnessS(this.selfParent(w));
        }
        return votedOn == w;
    }

    @NonNull
    private List<EventImpl> getStronglySeenInPreviousRound(EventImpl event) {
        int numMembers = this.roster.rosterEntries().size();
        ArrayList<EventImpl> stronglySeen = new ArrayList<EventImpl>(numMembers);
        for (long m = 0L; m < (long)numMembers; ++m) {
            EventImpl s = this.stronglySeeS1(event, m);
            if (s == null) continue;
            stronglySeen.add(s);
        }
        return stronglySeen;
    }

    @NonNull
    private ConsensusRound roundDecided(RoundElections roundElections) {
        List<EventImpl> judges = roundElections.findAllJudges();
        long decidedRoundNumber = this.rounds.getElectionRoundNumber();
        this.checkJudges(judges, decidedRoundNumber);
        this.rounds.currentElectionDecided();
        List<PlatformEvent> consensusEvents = this.findConsensusEvents(judges, decidedRoundNumber, ConsensusUtils.generateWhitening(judges)).stream().map(EventImpl::getBaseEvent).toList();
        this.consensusMetrics.consensusReachedOnRound();
        if (consensusEvents.isEmpty()) {
            if (this.lastConsensusTime == null) {
                List<Instant> judgeTimes = judges.stream().map(EventImpl::getTimeCreated).sorted().toList();
                this.lastConsensusTime = judgeTimes.get(judgeTimes.size() / 2);
            } else {
                this.lastConsensusTime = ConsensusUtils.calcMinTimestampForNextEvent(this.lastConsensusTime);
            }
        }
        long nonAncientThreshold = this.rounds.getAncientThreshold();
        long nonExpiredThreshold = this.rounds.getExpiredThreshold();
        List<JudgeId> judgeIds = judges.stream().map(event -> new JudgeId(event.getCreatorId().id(), event.getBaseHash().getBytes())).toList();
        return new ConsensusRound(this.roster, consensusEvents, new EventWindow(decidedRoundNumber, decidedRoundNumber + 1L, nonAncientThreshold, nonExpiredThreshold), new ConsensusSnapshot(decidedRoundNumber, this.rounds.getMinimumJudgeInfoList(), this.numConsensus, CommonUtils.toPbjTimestamp((Instant)this.lastConsensusTime), judgeIds), this.pcesMode, this.time.now());
    }

    private void checkJudges(@NonNull List<EventImpl> judges, long decidedRoundNumber) {
        long judgeWeights = judges.stream().mapToLong(event -> this.getWeight(event.getCreatorId())).sum();
        this.consensusMetrics.judgeWeights(judgeWeights);
        if (judges.isEmpty()) {
            this.markerFileWriter.writeMarkerFile(NO_JUDGES_MARKER_FILE);
            this.noJudgeLogger.error(LogMarker.ERROR.getMarker(), "no judges in round = {}", new Object[]{decidedRoundNumber});
        } else if (!Threshold.SUPER_MAJORITY.isSatisfiedBy(judgeWeights, this.rosterTotalWeight)) {
            this.markerFileWriter.writeMarkerFile(NO_SUPER_MAJORITY_MARKER_FILE);
            this.noSuperMajorityLogger.error(LogMarker.ERROR.getMarker(), "less than a super majority of weight on judges.  round = {}, judgesWeight = {}, percentage = {}", new Object[]{decidedRoundNumber, judgeWeights, (double)judgeWeights / (double)this.rosterTotalWeight});
        }
    }

    @NonNull
    private List<EventImpl> findConsensusEvents(@NonNull List<EventImpl> judges, long decidedRound, @NonNull byte[] whitening) {
        List<EventImpl> consensus = this.search.commonAncestorsOf(judges, this::nonConsensusNonAncient);
        consensus.forEach(e -> ConsensusImpl.setIsConsensusTrue(e, decidedRound));
        ConsensusSorter.sort(consensus, whitening);
        this.setConsensusOrder(consensus);
        consensus.forEach(e -> e.setRecTimes(null));
        return consensus;
    }

    private static void setIsConsensusTrue(@NonNull EventImpl event, long receivedRound) {
        event.setRoundReceived(receivedRound);
        event.setConsensus(true);
        List<Instant> times = event.getRecTimes();
        event.setPreliminaryConsensusTimestamp(times.get(times.size() / 2));
    }

    private void setConsensusOrder(@NonNull Collection<EventImpl> events) {
        for (EventImpl e : events) {
            Instant minTimestamp;
            Instant instant = minTimestamp = this.lastConsensusTime == null ? null : ConsensusUtils.calcMinTimestampForNextEvent(this.lastConsensusTime);
            if (minTimestamp != null && e.getPreliminaryConsensusTimestamp().isBefore(minTimestamp)) {
                e.setPreliminaryConsensusTimestamp(minTimestamp);
            }
            e.getBaseEvent().setConsensusData(new EventConsensusData(HapiUtils.asTimestamp((Instant)e.getPreliminaryConsensusTimestamp()), this.numConsensus));
            this.lastConsensusTime = EventUtils.getLastTransTime(e.getBaseEvent());
            ++this.numConsensus;
            this.consensusMetrics.consensusReached(e);
        }
    }

    private boolean nonConsensusNonAncient(@NonNull EventImpl e) {
        return !e.isConsensus() && !this.ancient(e);
    }

    @Nullable
    private EventImpl timedStronglySeeP(@Nullable EventImpl x, long m) {
        long t = System.nanoTime();
        EventImpl result = this.stronglySeeP(x, m);
        t = System.nanoTime() - t;
        this.consensusMetrics.dotProductTime(t);
        return result;
    }

    private static boolean notRelevantForConsensus(@NonNull EventImpl e) {
        return e.getRoundCreated() == 0L;
    }

    private boolean witness(@NonNull EventImpl x) {
        return this.round(x) > 0L && (!x.hasSelfParent() || this.round(x) != this.round(this.selfParent(x)));
    }

    @Nullable
    private EventImpl selfParent(@NonNull EventImpl x) {
        return this.ancient((EventImpl)x.getSelfParent()) ? null : (EventImpl)x.getSelfParent();
    }

    @Nullable
    private EventImpl otherParent(@NonNull EventImpl x) {
        return this.ancient((EventImpl)x.getOtherParent()) ? null : (EventImpl)x.getOtherParent();
    }

    private boolean ancient(@Nullable EventImpl x) {
        return x == null || x.getBirthRound() < this.rounds.getAncientThreshold();
    }

    private long parentRound(@Nullable EventImpl x) {
        if (x == null) {
            return 0L;
        }
        return Math.max(this.round(this.selfParent(x)), this.round(this.otherParent(x)));
    }

    @Nullable
    private EventImpl lastSee(@Nullable EventImpl x, long m) {
        if (x == null) {
            return null;
        }
        if (ConsensusImpl.notRelevantForConsensus(x)) {
            return null;
        }
        if (x.sizeLastSee() != 0) {
            return x.getLastSee((int)m);
        }
        int numMembers = this.roster.rosterEntries().size();
        x.initLastSee(numMembers);
        EventImpl op = this.otherParent(x);
        EventImpl sp = this.selfParent(x);
        for (int mm = 0; mm < numMembers; ++mm) {
            long lsspGen;
            if (this.creatorIndexEquals(x, mm)) {
                x.setLastSee(mm, x);
                continue;
            }
            if (sp == null && op == null) {
                x.setLastSee(mm, null);
                continue;
            }
            EventImpl lsop = this.lastSee(op, mm);
            EventImpl lssp = this.lastSee(sp, mm);
            long lsopGen = lsop == null ? 0L : (long)lsop.getDeGen();
            long l = lsspGen = lssp == null ? 0L : (long)lssp.getDeGen();
            if (this.round(lsop) > this.round(lssp) || lsopGen > lsspGen && this.firstSee(op, mm) == this.firstSee(sp, mm)) {
                x.setLastSee(mm, lsop);
                continue;
            }
            x.setLastSee(mm, lssp);
        }
        return x.getLastSee((int)m);
    }

    @Nullable
    private EventImpl seeThru(@Nullable EventImpl x, int m, int m2) {
        if (x == null) {
            return null;
        }
        if (ConsensusImpl.notRelevantForConsensus(x)) {
            return null;
        }
        if (m == m2 && this.creatorIndexEquals(x, m2)) {
            return this.firstSelfWitnessS(this.selfParent(x));
        }
        return this.firstSee(this.lastSee(x, m2), m);
    }

    @Nullable
    private EventImpl stronglySeeP(@Nullable EventImpl x, long m) {
        if (x == null) {
            return null;
        }
        if (ConsensusImpl.notRelevantForConsensus(x)) {
            return null;
        }
        if (x.sizeStronglySeeP() != 0) {
            return x.getStronglySeeP((int)m);
        }
        int numMembers = this.roster.rosterEntries().size();
        EventImpl sp = this.selfParent(x);
        EventImpl op = this.otherParent(x);
        long prx = this.parentRound(x);
        long prsp = this.parentRound(sp);
        long prop = this.parentRound(op);
        x.initStronglySeeP(numMembers);
        for (int mm = 0; mm < numMembers; ++mm) {
            if (this.stronglySeeP(sp, mm) != null && prx == prsp) {
                x.setStronglySeeP(mm, this.stronglySeeP(sp, mm));
                continue;
            }
            if (this.stronglySeeP(op, mm) != null && prx == prop) {
                x.setStronglySeeP(mm, this.stronglySeeP(op, mm));
                continue;
            }
            EventImpl st = this.seeThru(x, mm, mm);
            if (this.round(st) != prx) {
                x.setStronglySeeP(mm, null);
                continue;
            }
            long weight = 0L;
            for (int m3 = 0; m3 < numMembers; ++m3) {
                if (this.seeThru(x, mm, m3) != st) continue;
                weight += this.getWeight(m3);
            }
            if (Threshold.SUPER_MAJORITY.isSatisfiedBy(weight, this.rosterTotalWeight)) {
                x.setStronglySeeP(mm, st);
                continue;
            }
            x.setStronglySeeP(mm, null);
        }
        return x.getStronglySeeP((int)m);
    }

    private long round(@Nullable EventImpl x) {
        long rop;
        if (x == null) {
            return 0L;
        }
        if (x.getRoundCreated() >= 0L) {
            return x.getRoundCreated();
        }
        if (this.rounds.isOlderThanDecidedRoundGeneration(x) || x.isConsensus()) {
            x.setRoundCreated(0L);
            return 0L;
        }
        if (!x.hasSelfParent() && !x.hasOtherParent()) {
            x.setRoundCreated(1L);
            return x.getRoundCreated();
        }
        EventImpl selfParent = this.selfParent(x);
        EventImpl otherParent = this.otherParent(x);
        long rsp = this.round(selfParent);
        if (rsp > (rop = this.round(otherParent)) && !this.hasSuperMajority(selfParent)) {
            x.setRoundCreated(rsp);
            return x.getRoundCreated();
        }
        if (rop > rsp && !this.hasSuperMajority(otherParent)) {
            x.setRoundCreated(rop);
            return x.getRoundCreated();
        }
        if (rsp == 0L && rop == 0L) {
            x.setRoundCreated(0L);
            return x.getRoundCreated();
        }
        int numMembers = this.roster.rosterEntries().size();
        long weight = 0L;
        int numStronglySeen = 0;
        for (int m = 0; m < numMembers; ++m) {
            if (this.timedStronglySeeP(x, m) == null) continue;
            weight += this.getWeight(m);
            ++numStronglySeen;
        }
        this.consensusMetrics.witnessesStronglySeen(numStronglySeen);
        if (Threshold.SUPER_MAJORITY.isSatisfiedBy(weight, this.rosterTotalWeight)) {
            x.setRoundCreated(1L + this.parentRound(x));
            this.consensusMetrics.roundIncrementedByStronglySeen();
            return x.getRoundCreated();
        }
        x.setRoundCreated(this.parentRound(x));
        return x.getRoundCreated();
    }

    private boolean hasSuperMajority(@Nullable EventImpl x) {
        if (x == null) {
            return false;
        }
        Integer memberIndex = this.rosterIndicesMap.get(x.getCreatorId().id());
        if (memberIndex == null) {
            return false;
        }
        long weight = this.getWeight(memberIndex);
        return Threshold.SUPER_MAJORITY.isSatisfiedBy(weight, this.rosterTotalWeight);
    }

    @Nullable
    private EventImpl firstSelfWitnessS(@Nullable EventImpl x) {
        if (x == null) {
            return null;
        }
        if (ConsensusImpl.notRelevantForConsensus(x)) {
            return null;
        }
        if (x.getFirstSelfWitnessS() != null) {
            return x.getFirstSelfWitnessS();
        }
        if (this.round(x) > this.round(this.selfParent(x))) {
            x.setFirstSelfWitnessS(x);
        } else {
            x.setFirstSelfWitnessS(this.firstSelfWitnessS(this.selfParent(x)));
        }
        return x.getFirstSelfWitnessS();
    }

    @Nullable
    private EventImpl firstWitnessS(@Nullable EventImpl x) {
        if (x == null) {
            return null;
        }
        if (ConsensusImpl.notRelevantForConsensus(x)) {
            return null;
        }
        if (x.getFirstWitnessS() != null) {
            return x.getFirstWitnessS();
        }
        if (this.round(x) > this.parentRound(x)) {
            x.setFirstWitnessS(x);
        } else if (this.round(x) == this.round(this.selfParent(x))) {
            x.setFirstWitnessS(this.firstWitnessS(this.selfParent(x)));
        } else {
            x.setFirstWitnessS(this.firstWitnessS(this.otherParent(x)));
        }
        return x.getFirstWitnessS();
    }

    @Nullable
    private EventImpl stronglySeeS1(@Nullable EventImpl x, long m) {
        return this.timedStronglySeeP(this.firstWitnessS(x), m);
    }

    @Nullable
    private EventImpl firstSee(@Nullable EventImpl x, long m) {
        return this.firstSelfWitnessS(this.lastSee(x, m));
    }

    private long getWeight(@NonNull NodeId nodeId) {
        if (!this.rosterIndicesMap.containsKey(nodeId.id())) {
            return 0L;
        }
        return ((RosterEntry)this.roster.rosterEntries().get(this.rosterIndicesMap.get(nodeId.id()))).weight();
    }

    private long getWeight(int nodeIndex) {
        return ((RosterEntry)this.roster.rosterEntries().get(nodeIndex)).weight();
    }

    private boolean creatorIndexEquals(@NonNull EventImpl e, int index) {
        if (!this.rosterIndicesMap.containsKey(e.getCreatorId().id())) {
            return false;
        }
        return this.rosterIndicesMap.get(e.getCreatorId().id()) == index;
    }

    @Override
    public long getMaxRound() {
        return this.rounds.getMaxRound();
    }

    @Override
    public long getFameDecidedBelow() {
        return this.rounds.getFameDecidedBelow();
    }
}

