/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.event.branching;

import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.platform.event.branching.BranchDetector;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hiero.consensus.model.event.EventDescriptorWrapper;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.NodeId;

public class DefaultBranchDetector
implements BranchDetector {
    private EventWindow currentEventWindow;
    private final List<NodeId> nodes = new ArrayList<NodeId>();
    private final Map<NodeId, EventDescriptorWrapper> mostRecentEvents = new HashMap<NodeId, EventDescriptorWrapper>();

    public DefaultBranchDetector(@NonNull Roster currentRoster) {
        this.nodes.addAll(currentRoster.rosterEntries().stream().map(re -> NodeId.of((long)re.nodeId())).toList());
        Collections.sort(this.nodes);
    }

    @Override
    @Nullable
    public PlatformEvent checkForBranches(@NonNull PlatformEvent event) {
        if (this.currentEventWindow == null) {
            throw new IllegalStateException("Event window must be set before adding events");
        }
        if (this.currentEventWindow.isAncient(event)) {
            return null;
        }
        NodeId creator = event.getCreatorId();
        EventDescriptorWrapper previousEvent = this.mostRecentEvents.get(creator);
        EventDescriptorWrapper selfParent = event.getSelfParent();
        boolean branching = previousEvent != null && !previousEvent.equals((Object)selfParent);
        this.mostRecentEvents.put(creator, event.getDescriptor());
        return branching ? event : null;
    }

    @Override
    public void updateEventWindow(@NonNull EventWindow eventWindow) {
        this.currentEventWindow = eventWindow;
        for (NodeId nodeId : this.nodes) {
            EventDescriptorWrapper mostRecentEvent = this.mostRecentEvents.get(nodeId);
            if (mostRecentEvent == null || !eventWindow.isAncient(mostRecentEvent)) continue;
            this.mostRecentEvents.put(nodeId, null);
        }
    }

    @Override
    public void clear() {
        this.currentEventWindow = null;
        this.mostRecentEvents.clear();
    }
}

