/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.addressbook;

import com.hedera.hapi.node.base.ServiceEndpoint;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.platform.test.fixtures.crypto.PreGeneratedX509Certs;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.security.cert.CertificateEncodingException;
import java.util.Objects;
import java.util.Random;
import org.hiero.base.utility.test.fixtures.RandomUtils;
import org.hiero.consensus.model.roster.SerializableX509Certificate;

public class RandomRosterEntryBuilder {
    private final Random random;
    private Long nodeId;
    private Long weight;
    private Integer port;
    private String hostname;
    private SerializableX509Certificate sigCert;
    private long minimumWeight = 0L;
    private long maximumWeight = 0x1FFFFFFFFFFFFFL;

    @NonNull
    public static RandomRosterEntryBuilder create(@NonNull Random random) {
        return new RandomRosterEntryBuilder(random);
    }

    private RandomRosterEntryBuilder(@NonNull Random random) {
        this.random = Objects.requireNonNull(random);
    }

    @NonNull
    public RosterEntry build() {
        if (this.nodeId == null) {
            this.nodeId = this.random.nextLong(0L, Long.MAX_VALUE);
        }
        if (this.weight == null) {
            this.weight = this.random.nextLong(this.minimumWeight, this.maximumWeight);
        }
        if (this.port == null) {
            this.port = this.random.nextInt(1, 65535);
        }
        if (this.hostname == null) {
            this.hostname = RandomUtils.randomIp((Random)this.random);
        }
        if (this.sigCert == null) {
            this.sigCert = PreGeneratedX509Certs.getSigCert(this.nodeId);
        }
        try {
            return RosterEntry.newBuilder().nodeId(this.nodeId.longValue()).weight(this.weight.longValue()).gossipCaCertificate(Bytes.wrap((byte[])this.sigCert.getCertificate().getEncoded())).gossipEndpoint(new ServiceEndpoint[]{ServiceEndpoint.newBuilder().domainName(this.hostname).port(this.port.intValue()).build()}).build();
        }
        catch (CertificateEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @NonNull
    public RandomRosterEntryBuilder withNodeId(long nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    @NonNull
    public RandomRosterEntryBuilder withWeight(long weight) {
        this.weight = weight;
        return this;
    }

    @NonNull
    public RandomRosterEntryBuilder withPort(int port) {
        this.port = port;
        return this;
    }

    @NonNull
    public RandomRosterEntryBuilder withHostname(@NonNull String hostname) {
        this.hostname = Objects.requireNonNull(hostname);
        return this;
    }

    @NonNull
    public RandomRosterEntryBuilder withSigCert(@NonNull SerializableX509Certificate sigCert) {
        this.sigCert = Objects.requireNonNull(sigCert);
        return this;
    }

    @NonNull
    public RandomRosterEntryBuilder withMinimumWeight(long minimumWeight) {
        this.minimumWeight = minimumWeight;
        return this;
    }

    @NonNull
    public RandomRosterEntryBuilder withMaximumWeight(long maximumWeight) {
        this.maximumWeight = maximumWeight;
        return this;
    }
}

