/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.model.internal.monitor;

import com.swirlds.common.metrics.DurationGauge;
import com.swirlds.metrics.api.IntegerGauge;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.hiero.base.CompareTo;

public class HealthMonitorMetrics {
    private static final DurationGauge.Config DURATION_GAUGE_CONFIG = new DurationGauge.Config("platform", "unhealthyDuration", ChronoUnit.SECONDS).withDescription("The duration that the most unhealthy scheduler has been in an unhealthy state.");
    private final DurationGauge unhealthyDuration;
    private static final IntegerGauge.Config HEALTHY_CONFIG = new IntegerGauge.Config("platform", "healthy").withDescription("1 if the platform is healthy, 0 otherwise. Triggers once unhealthyDuration metric crosses configured threshold.");
    private final IntegerGauge healthy;
    private final Duration healthThreshold;

    public HealthMonitorMetrics(@NonNull Metrics metrics, @NonNull Duration healthLogThreshold) {
        this.unhealthyDuration = (DurationGauge)metrics.getOrCreate((MetricConfig)DURATION_GAUGE_CONFIG);
        this.healthy = (IntegerGauge)metrics.getOrCreate((MetricConfig)HEALTHY_CONFIG);
        this.healthy.set(1);
        this.healthThreshold = healthLogThreshold;
    }

    public void reportUnhealthyDuration(@NonNull Duration duration) {
        this.unhealthyDuration.set(duration);
        this.healthy.set(CompareTo.isLessThan((Comparable)duration, (Object)this.healthThreshold) ? 1 : 0);
    }
}

