/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.editor;

import com.swirlds.common.formatting.TextEffect;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.route.MerkleRoute;
import com.swirlds.common.merkle.route.MerkleRouteUtils;
import java.nio.file.Path;

final class StateEditorUtils {
    private StateEditorUtils() {
    }

    public static String formatFile(Path file) {
        return TextEffect.BRIGHT_CYAN.apply(file.toString());
    }

    public static String formatNode(MerkleNode node) {
        if (node == null) {
            return TextEffect.BRIGHT_YELLOW.apply("null");
        }
        return StateEditorUtils.formatRoute(node.getRoute()) + " " + StateEditorUtils.formatNodeType(node);
    }

    public static String formatNodeType(MerkleNode node) {
        if (node == null) {
            return TextEffect.BRIGHT_YELLOW.apply("null");
        }
        return TextEffect.BRIGHT_YELLOW.apply(node.getClass().getSimpleName());
    }

    public static String formatRoute(MerkleRoute route) {
        return TextEffect.BRIGHT_RED.apply(MerkleRouteUtils.merkleRouteToPathFormat((MerkleRoute)route));
    }

    public static String formatChildIndex(int index) {
        return TextEffect.BRIGHT_GREEN.apply(String.valueOf(index));
    }

    public static String formatParent(MerkleNode parent, int childIndex) {
        return StateEditorUtils.formatNode(parent) + "[" + StateEditorUtils.formatChildIndex(childIndex) + "]";
    }
}

