/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.test.fixtures;

import com.swirlds.state.spi.WritableSingletonStateBase;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class FunctionWritableSingletonState<S>
extends WritableSingletonStateBase<S> {
    private final Supplier<S> backingStoreAccessor;
    private final Consumer<S> backingStoreMutator;

    public FunctionWritableSingletonState(int stateId, String label, @NonNull Supplier<S> backingStoreAccessor, @NonNull Consumer<S> backingStoreMutator) {
        super(stateId, label);
        this.backingStoreAccessor = Objects.requireNonNull(backingStoreAccessor);
        this.backingStoreMutator = Objects.requireNonNull(backingStoreMutator);
    }

    protected S readFromDataSource() {
        return this.backingStoreAccessor.get();
    }

    protected void putIntoDataSource(@NonNull S value) {
        this.backingStoreMutator.accept(value);
    }

    protected void removeFromDataSource() {
        this.backingStoreMutator.accept(null);
    }
}

