/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.config;

import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.config.api.source.ConfigSource;
import com.swirlds.config.extensions.sources.LegacyFileConfigSource;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.config.internal.ConfigMappings;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultConfiguration {
    private static final Logger logger = LogManager.getLogger(DefaultConfiguration.class);

    private DefaultConfiguration() {
    }

    @NonNull
    public static Configuration buildBasicConfiguration(@NonNull ConfigurationBuilder configurationBuilder) throws IOException {
        return DefaultConfiguration.buildBasicConfiguration(configurationBuilder, FileUtils.getAbsolutePath((String)"settings.txt"), Collections.emptyList());
    }

    @NonNull
    public static Configuration buildBasicConfiguration(@NonNull ConfigurationBuilder configurationBuilder, @NonNull Path settingsPath) throws IOException {
        return DefaultConfiguration.buildBasicConfiguration(configurationBuilder, settingsPath, Collections.emptyList());
    }

    @NonNull
    public static Configuration buildBasicConfiguration(@NonNull ConfigurationBuilder configurationBuilder, @NonNull Path settingsPath, @NonNull List<Path> configurationPaths) throws IOException {
        LegacyFileConfigSource settingsConfigSource = LegacyFileConfigSource.ofSettingsFile((Path)settingsPath);
        ConfigSource mappedSettingsConfigSource = ConfigMappings.addConfigMapping((ConfigSource)settingsConfigSource);
        configurationBuilder.autoDiscoverExtensions().withSource(mappedSettingsConfigSource);
        for (Path configurationPath : configurationPaths) {
            logger.info(LogMarker.CONFIG.getMarker(), "Loading configuration from {}", (Object)configurationPath);
            configurationBuilder.withSource((ConfigSource)new LegacyFileConfigSource(configurationPath));
        }
        return configurationBuilder.build();
    }
}

