/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.stack.primitive;

import org.eclipse.collections.api.block.function.primitive.DoubleIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoubleIntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.stack.ImmutableStack;
import org.eclipse.collections.api.stack.primitive.DoubleStack;

public interface ImmutableDoubleStack
extends DoubleStack {
    @Override
    default public ImmutableDoubleStack tap(DoubleProcedure procedure) {
        this.forEach(procedure);
        return this;
    }

    public ImmutableDoubleStack push(double var1);

    public ImmutableDoubleStack pop();

    public ImmutableDoubleStack pop(int var1);

    @Override
    public ImmutableDoubleStack select(DoublePredicate var1);

    @Override
    public ImmutableDoubleStack reject(DoublePredicate var1);

    public <V> ImmutableStack<V> collect(DoubleToObjectFunction<? extends V> var1);

    @Override
    default public ImmutableDoubleStack selectWithIndex(DoubleIntPredicate predicate) {
        int[] index = new int[]{0};
        return this.select(each -> {
            int n = index[0];
            index[0] = n + 1;
            return predicate.accept(each, n);
        });
    }

    @Override
    default public ImmutableDoubleStack rejectWithIndex(DoubleIntPredicate predicate) {
        int[] index = new int[]{0};
        return this.reject(each -> {
            int n = index[0];
            index[0] = n + 1;
            return predicate.accept(each, n);
        });
    }

    default public <V> ImmutableStack<V> collectWithIndex(DoubleIntToObjectFunction<? extends V> function) {
        int[] index = new int[]{0};
        return this.collect((double each) -> {
            int n = index[0];
            index[0] = n + 1;
            return function.value(each, n);
        });
    }
}

