/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.cli.logging;

import com.swirlds.cli.logging.HtmlGenerator;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.node.NodeId;

public class LogProcessor {
    private static final Logger logger = LogManager.getLogger(LogProcessor.class);
    private static final int MAX_LINES = 500000;

    private LogProcessor() {
    }

    @NonNull
    private static Map<NodeId, Path> findLogFiles(@NonNull Path inputDirectory) throws IOException {
        HashMap<NodeId, Path> logFilesByNode = new HashMap<NodeId, Path>();
        try (Stream<Path> nodeDirectories = Files.list(inputDirectory).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
            nodeDirectories.forEach(subdirectory -> {
                String subdirectoryName = subdirectory.getFileName().toString();
                Matcher nodeDirectoryMatcher = Pattern.compile("node0*(\\d+)").matcher(subdirectoryName);
                if (!nodeDirectoryMatcher.matches()) {
                    return;
                }
                Path logFile = subdirectory.resolve("swirlds.log");
                if (Files.exists(logFile, new LinkOption[0])) {
                    NodeId nodeId = NodeId.of((long)Integer.parseInt(subdirectoryName.substring(4)));
                    logFilesByNode.put(nodeId, logFile);
                    logger.info(LogMarker.CLI.getMarker(), "Found log file: {}", (Object)logFile);
                }
            });
        }
        return logFilesByNode;
    }

    public static void processLogs(@Nullable Path inputDirectory, @Nullable Path outputPath) throws IOException {
        Path actualInputDirectory = Objects.requireNonNullElseGet(inputDirectory, FileUtils::getAbsolutePath);
        Path actualOutputPath = Objects.requireNonNullElseGet(outputPath, () -> actualInputDirectory.resolve("swirlds-logs.html"));
        Map<NodeId, Path> logFilesByNode = LogProcessor.findLogFiles(actualInputDirectory);
        HashMap<NodeId, List<String>> logLinesByNode = new HashMap<NodeId, List<String>>();
        long lineCount = 0L;
        for (Map.Entry<NodeId, Path> entry : logFilesByNode.entrySet()) {
            List<String> logLines;
            try (BufferedReader reader = new BufferedReader(new FileReader(entry.getValue().toFile()));){
                logLines = reader.lines().toList();
            }
            if ((lineCount += (long)logLines.size()) > 500000L) {
                logger.info(LogMarker.CLI.getMarker(), "Aborting log processing because there are too many lines");
                return;
            }
            logLinesByNode.put(entry.getKey(), logLines);
        }
        String htmlPage = HtmlGenerator.generateHtmlPage(logLinesByNode);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(actualOutputPath.toString(), false));){
            writer.write(htmlPage);
        }
        catch (IOException e) {
            logger.info(LogMarker.CLI.getMarker(), "Failed to write formatted log file to {}", (Object)outputPath);
        }
    }
}

