/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures;

import com.swirlds.common.test.fixtures.Randotron;
import com.swirlds.common.test.fixtures.WeightGenerator;
import java.util.ArrayList;
import java.util.List;

public class GaussianWeightGenerator
implements WeightGenerator {
    private final long networkWeight;
    private final long averageNodeWeight;
    private final long weightStandardDeviation;

    private GaussianWeightGenerator(long networkWeight, long averageNodeWeight, long weightStandardDeviation) {
        this.networkWeight = networkWeight;
        this.averageNodeWeight = averageNodeWeight;
        this.weightStandardDeviation = weightStandardDeviation;
    }

    public static GaussianWeightGenerator withNetworkWeight(long networkWeight, long weightStandardDeviation) {
        return new GaussianWeightGenerator(networkWeight, -1L, weightStandardDeviation);
    }

    public static GaussianWeightGenerator withAverageNodeWeight(long averageNodeWeight, long weightStandardDeviation) {
        return new GaussianWeightGenerator(-1L, averageNodeWeight, weightStandardDeviation);
    }

    @Override
    public List<Long> getWeights(long seed, int numberOfNodes) {
        long averageWeight = this.averageNodeWeight == -1L ? this.networkWeight / (long)numberOfNodes : this.averageNodeWeight;
        Randotron r = Randotron.create(seed);
        ArrayList<Long> nodeWeights = new ArrayList<Long>(numberOfNodes);
        for (int i = 0; i < numberOfNodes; ++i) {
            nodeWeights.add(Math.max(0L, (long)((double)averageWeight + r.nextGaussian() * (double)this.weightStandardDeviation)));
        }
        return nodeWeights;
    }
}

