/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.test.fixtures;

import com.swirlds.state.spi.CommittableWritableStates;
import com.swirlds.state.spi.WritableKVState;
import com.swirlds.state.spi.WritableKVStateBase;
import com.swirlds.state.spi.WritableQueueState;
import com.swirlds.state.spi.WritableQueueStateBase;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.state.spi.WritableSingletonStateBase;
import com.swirlds.state.spi.WritableStates;
import com.swirlds.state.test.fixtures.MapWritableKVState;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class MapWritableStates
implements WritableStates,
CommittableWritableStates {
    private final Map<Integer, ?> states;
    @Nullable
    private final Runnable onCommit;

    public MapWritableStates(@NonNull Map<Integer, ?> states) {
        this(states, null);
    }

    public MapWritableStates(@NonNull Map<Integer, ?> states, @Nullable Runnable onCommit) {
        this.states = Objects.requireNonNull(states);
        this.onCommit = onCommit;
    }

    @NonNull
    public <K, V> WritableKVState<K, V> get(int stateId) {
        Object state = this.states.get(stateId);
        if (state == null) {
            throw new IllegalArgumentException("Unknown K/V state ID " + stateId);
        }
        return (WritableKVState)state;
    }

    @NonNull
    public <T> WritableSingletonState<T> getSingleton(int stateId) {
        Object state = this.states.get(stateId);
        if (state == null) {
            throw new IllegalArgumentException("Unknown singleton state ID " + stateId);
        }
        return (WritableSingletonState)state;
    }

    @NonNull
    public <E> WritableQueueState<E> getQueue(int stateId) {
        Object state = this.states.get(stateId);
        if (state == null) {
            throw new IllegalArgumentException("Unknown queue state ID " + stateId);
        }
        return (WritableQueueState)state;
    }

    public boolean contains(int stateId) {
        return this.states.containsKey(stateId);
    }

    @NonNull
    public Set<Integer> stateIds() {
        return Collections.unmodifiableSet(this.states.keySet());
    }

    public int size() {
        return this.states.size();
    }

    public void commit() {
        this.states.values().forEach(state -> {
            if (state instanceof WritableKVStateBase) {
                WritableKVStateBase kv = (WritableKVStateBase)state;
                kv.commit();
            } else if (state instanceof WritableSingletonStateBase) {
                WritableSingletonStateBase singleton = (WritableSingletonStateBase)state;
                singleton.commit();
            } else if (state instanceof WritableQueueStateBase) {
                WritableQueueStateBase queue = (WritableQueueStateBase)state;
                queue.commit();
            } else {
                throw new IllegalStateException("Unknown state type " + state.getClass().getName());
            }
        });
        if (this.onCommit != null) {
            this.onCommit.run();
        }
    }

    public String toString() {
        return "MapWritableStates{states=" + String.valueOf(this.states) + "}";
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<Integer, Object> states = new HashMap<Integer, Object>();

        @NonNull
        public Builder state(@NonNull MapWritableKVState state) {
            this.states.put(state.getStateId(), (Object)state);
            return this;
        }

        @NonNull
        public Builder state(@NonNull WritableSingletonState<?> state) {
            this.states.put(state.getStateId(), state);
            return this;
        }

        @NonNull
        public Builder state(@NonNull WritableQueueState<?> state) {
            this.states.put(state.getStateId(), state);
            return this;
        }

        @NonNull
        public MapWritableStates build() {
            return new MapWritableStates(new HashMap<Integer, Object>(this.states));
        }
    }
}

