/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.metrics.impl;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.metrics.api.IntegerAccumulator;
import com.swirlds.metrics.api.Metric;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.snapshot.Snapshot;
import com.swirlds.metrics.impl.AbstractMetric;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntBinaryOperator;
import java.util.function.IntSupplier;

public class DefaultIntegerAccumulator
extends AbstractMetric
implements IntegerAccumulator {
    private final AtomicInteger container;
    private final IntBinaryOperator accumulator;
    private final IntSupplier initializer;

    public DefaultIntegerAccumulator(@NonNull IntegerAccumulator.Config config) {
        super((MetricConfig<?, ?>)config);
        this.accumulator = config.getAccumulator();
        int initialValue = config.getInitialValue();
        this.initializer = config.getInitializer() != null ? config.getInitializer() : () -> initialValue;
        this.container = new AtomicInteger(this.initializer.getAsInt());
    }

    public int getInitialValue() {
        return this.initializer.getAsInt();
    }

    @NonNull
    public List<Snapshot.SnapshotEntry> takeSnapshot() {
        return List.of(new Snapshot.SnapshotEntry(Metric.ValueType.VALUE, (Object)this.container.getAndSet(this.initializer.getAsInt())));
    }

    public int get() {
        return this.container.get();
    }

    public void update(int other) {
        this.container.accumulateAndGet(other, this.accumulator);
    }

    @Override
    public void reset() {
        this.container.set(this.initializer.getAsInt());
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("value", (Object)this.get()).toString();
    }
}

