/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.constructable.internal;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import org.hiero.base.constructable.ConstructableClass;
import org.hiero.base.constructable.ConstructableIgnored;
import org.hiero.base.constructable.NoArgsConstructor;
import org.hiero.base.constructable.RuntimeConstructable;
import org.hiero.base.constructable.URLClassLoaderWithLookup;
import org.hiero.base.constructable.internal.ConstructableClasses;

public final class ConstructableScanner {
    private ConstructableScanner() {
    }

    public static Collection<ConstructableClasses<?>> getConstructableClasses(String packagePrefix, URLClassLoaderWithLookup additionalClassloader) {
        HashMap<Class, ConstructableClasses> map = new HashMap<Class, ConstructableClasses>();
        ClassGraph classGraph = new ClassGraph().enableClassInfo().whitelistPackages(new String[]{packagePrefix});
        if (additionalClassloader != null) {
            classGraph.addClassLoader((ClassLoader)additionalClassloader);
        }
        try (ScanResult scanResult = classGraph.scan();){
            for (ClassInfo classInfo : scanResult.getClassesImplementing(RuntimeConstructable.class.getCanonicalName())) {
                Class subType = classInfo.loadClass(RuntimeConstructable.class);
                if (ConstructableScanner.isSkippable(subType)) continue;
                Class<?> constructorType = ConstructableScanner.getConstructorType(subType);
                map.computeIfAbsent(constructorType, ConstructableClasses::new).addClass(subType);
            }
        }
        return map.values();
    }

    private static boolean isSkippable(Class<? extends RuntimeConstructable> subType) {
        return subType.isInterface() || Modifier.isAbstract(subType.getModifiers()) || subType.isAnnotationPresent(ConstructableIgnored.class);
    }

    private static Class<?> getConstructorType(Class<? extends RuntimeConstructable> subType) {
        return subType.isAnnotationPresent(ConstructableClass.class) ? subType.getAnnotation(ConstructableClass.class).constructorType() : NoArgsConstructor.class;
    }
}

