/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.state;

import com.hedera.hapi.block.stream.output.StateChanges;
import com.hedera.hapi.node.base.SemanticVersion;
import com.swirlds.config.api.Configuration;
import com.swirlds.merkledb.MerkleDbDataSourceBuilder;
import com.swirlds.platform.state.service.schemas.V0540PlatformStateSchema;
import com.swirlds.platform.state.service.schemas.V0540RosterBaseSchema;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.lifecycle.MigrationContext;
import com.swirlds.state.lifecycle.StateDefinition;
import com.swirlds.state.lifecycle.StateMetadata;
import com.swirlds.state.spi.CommittableWritableStates;
import com.swirlds.state.spi.WritableStates;
import com.swirlds.virtualmap.VirtualMap;
import com.swirlds.virtualmap.config.VirtualMapConfig;
import com.swirlds.virtualmap.internal.cache.VirtualNodeCache;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.hiero.base.constructable.ClassConstructorPair;
import org.hiero.base.constructable.ConstructableRegistry;
import org.hiero.base.constructable.ConstructableRegistryException;
import org.mockito.BDDMockito;
import org.mockito.Mockito;

public final class TestingAppStateInitializer {
    private TestingAppStateInitializer() {
    }

    public static void registerConstructablesForStorage(@NonNull Configuration configuration) {
        try {
            ConstructableRegistry registry = ConstructableRegistry.getInstance();
            registry.registerConstructable(new ClassConstructorPair(VirtualMap.class, () -> new VirtualMap(configuration)));
            registry.registerConstructable(new ClassConstructorPair(VirtualNodeCache.class, () -> new VirtualNodeCache((VirtualMapConfig)configuration.getConfigData(VirtualMapConfig.class))));
            ConstructableRegistry.getInstance().registerConstructable(new ClassConstructorPair(MerkleDbDataSourceBuilder.class, () -> new MerkleDbDataSourceBuilder(configuration)));
        }
        catch (ConstructableRegistryException e) {
            throw new IllegalStateException(e);
        }
    }

    public static List<StateChanges.Builder> initConsensusModuleStates(@NonNull MerkleNodeState state, @NonNull Configuration configuration) {
        ArrayList<StateChanges.Builder> list = new ArrayList<StateChanges.Builder>();
        list.addAll(TestingAppStateInitializer.initPlatformState(state));
        list.addAll(TestingAppStateInitializer.initRosterState(state, configuration));
        return list;
    }

    public static List<StateChanges.Builder> initPlatformState(@NonNull MerkleNodeState state) {
        V0540PlatformStateSchema schema = new V0540PlatformStateSchema(config -> SemanticVersion.newBuilder().minor(1).build());
        schema.statesToCreate().stream().sorted(Comparator.comparing(StateDefinition::stateId)).forEach(def -> {
            StateMetadata md = new StateMetadata("PlatformStateService", def);
            if (!def.singleton()) {
                throw new IllegalStateException("PlatformStateService only expected to use singleton states");
            }
            state.initializeState(md);
        });
        MigrationContext mockMigrationContext = (MigrationContext)Mockito.mock(MigrationContext.class);
        WritableStates writableStates = state.getWritableStates("PlatformStateService");
        BDDMockito.given((Object)mockMigrationContext.newStates()).willReturn((Object)writableStates);
        schema.migrate(mockMigrationContext);
        ((CommittableWritableStates)writableStates).commit();
        return Collections.emptyList();
    }

    public static List<StateChanges.Builder> initRosterState(@NonNull MerkleNodeState state, @NonNull Configuration configuration) {
        V0540RosterBaseSchema schema = new V0540RosterBaseSchema();
        schema.statesToCreate().stream().sorted(Comparator.comparing(StateDefinition::stateId)).forEach(def -> {
            StateMetadata md = new StateMetadata("RosterService", def);
            if (!def.singleton() && !def.onDisk()) {
                throw new IllegalStateException("RosterService only expected to use singleton and onDisk virtual map states");
            }
            state.initializeState(md);
        });
        MigrationContext mockMigrationContext = (MigrationContext)Mockito.mock(MigrationContext.class);
        WritableStates writableStates = state.getWritableStates("RosterService");
        BDDMockito.given((Object)mockMigrationContext.newStates()).willReturn((Object)writableStates);
        schema.migrate(mockMigrationContext);
        ((CommittableWritableStates)writableStates).commit();
        return Collections.emptyList();
    }
}

