/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.stats;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.common.metrics.noop.NoOpMetrics;
import com.swirlds.common.threading.framework.StoppableThread;
import com.swirlds.common.threading.framework.config.StoppableThreadConfiguration;
import com.swirlds.common.threading.manager.AdHocThreadManager;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.ParameterProvider;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.platform.state.NoOpConsensusStateEventHandler;
import com.swirlds.platform.system.DefaultSwirldMain;
import com.swirlds.platform.system.Platform;
import com.swirlds.platform.test.fixtures.state.TestingAppStateInitializer;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.StateLifecycleManager;
import com.swirlds.state.merkle.VirtualMapState;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Random;
import org.hiero.consensus.model.node.NodeId;

public class StatsDemoMain
extends DefaultSwirldMain<VirtualMapState> {
    static final Configuration CONFIGURATION = ConfigurationBuilder.create().autoDiscoverExtensions().build();
    private int bytesPerTrans = 1;
    private int transPerSecToCreate = 100;
    private Platform platform;
    private Random random = new Random();
    private static final SemanticVersion semanticVersion = SemanticVersion.newBuilder().major(1).build();
    private final StoppableThread transactionGenerator;
    long lastEventTime = System.nanoTime();
    double toCreate = 0.0;

    public StatsDemoMain() {
        this.transactionGenerator = ((StoppableThreadConfiguration)((StoppableThreadConfiguration)((StoppableThreadConfiguration)new StoppableThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setComponent("demo")).setThreadName("transaction-generator")).setMaximumRate(50.0)).setWork(this::generateTransactions).build();
    }

    private synchronized void generateTransactions() {
        byte[] transaction = new byte[this.bytesPerTrans];
        long now = System.nanoTime();
        double tps = this.transPerSecToCreate / this.platform.getRoster().rosterEntries().size();
        if (this.transPerSecToCreate > -1) {
            this.toCreate += ((double)now - (double)this.lastEventTime) * 1.0E-9 * tps;
        }
        this.lastEventTime = now;
        while (this.transPerSecToCreate <= -1 || !(this.toCreate < 1.0)) {
            this.random.nextBytes(transaction);
            if (!this.getTransactionPool().submitApplicationTransaction(Bytes.wrap((byte[])transaction))) break;
            this.toCreate -= 1.0;
        }
    }

    public void init(@NonNull Platform platform, @NonNull NodeId id) {
        this.platform = platform;
        String[] parameters = ParameterProvider.getInstance().getParameters();
        this.bytesPerTrans = parameters.length > 0 ? Integer.parseInt(parameters[0]) : 100;
        this.transPerSecToCreate = parameters.length > 1 ? Integer.parseInt(parameters[1]) : 200;
    }

    public void run() {
        this.transactionGenerator.start();
    }

    @NonNull
    public VirtualMapState newStateRoot() {
        VirtualMapState state = new VirtualMapState(CONFIGURATION, (Metrics)new NoOpMetrics());
        TestingAppStateInitializer.initConsensusModuleStates((MerkleNodeState)state, (Configuration)CONFIGURATION);
        return state;
    }

    @NonNull
    public ConsensusStateEventHandler newConsensusStateEvenHandler() {
        return NoOpConsensusStateEventHandler.NO_OP_CONSENSUS_STATE_EVENT_HANDLER;
    }

    public SemanticVersion getSemanticVersion() {
        return semanticVersion;
    }

    @NonNull
    public StateLifecycleManager getStateLifecycleManager() {
        throw new UnsupportedOperationException();
    }

    static {
        TestingAppStateInitializer.registerConstructablesForStorage((Configuration)CONFIGURATION);
    }
}

