/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.impl.EmptyIterator;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.block.procedure.AdaptObjectIntProcedureToProcedure;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.utility.Iterate;

public class FlatCollectCharToObjectIterable<V>
extends AbstractLazyIterable<V> {
    private final CharIterable iterable;
    private final CharToObjectFunction<? extends Iterable<V>> function;

    public FlatCollectCharToObjectIterable(CharIterable iterable, CharToObjectFunction<? extends Iterable<V>> function) {
        this.iterable = iterable;
        this.function = function;
    }

    public void each(Procedure<? super V> procedure) {
        this.iterable.forEach((CharProcedure & Serializable)each -> Iterate.forEach((Iterable)this.function.valueOf(each), procedure));
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super V> objectIntProcedure) {
        AdaptObjectIntProcedureToProcedure<? super V> innerProcedure = new AdaptObjectIntProcedureToProcedure<V>(objectIntProcedure);
        this.iterable.forEach((CharProcedure & Serializable)each -> {
            Iterable iterable = (Iterable)this.function.valueOf(each);
            Iterate.forEach(iterable, innerProcedure);
        });
    }

    @Override
    public <P> void forEachWith(Procedure2<? super V, ? super P> procedure, P parameter) {
        this.iterable.forEach((CharProcedure & Serializable)each -> Iterate.forEachWith((Iterable)this.function.valueOf(each), procedure, parameter));
    }

    public Iterator<V> iterator() {
        return new FlatCollectCharIterator(this.iterable, this.function);
    }

    @Override
    public V detect(Predicate<? super V> predicate) {
        Object[] result = new Object[1];
        this.iterable.anySatisfy((CharPredicate & Serializable)each -> {
            Iterable it = (Iterable)this.function.valueOf(each);
            return Iterate.anySatisfy(it, (Predicate & Serializable)each1 -> {
                if (predicate.accept(each1)) {
                    result[0] = each1;
                    return true;
                }
                return false;
            });
        });
        return (V)result[0];
    }

    @Override
    public Optional<V> detectOptional(Predicate<? super V> predicate) {
        Object[] result = new Object[1];
        this.iterable.anySatisfy((CharPredicate & Serializable)each -> {
            Iterable it = (Iterable)this.function.valueOf(each);
            if (this.iterable == null) {
                throw new NullPointerException();
            }
            return Iterate.anySatisfy(it, (Predicate & Serializable)each1 -> {
                if (predicate.accept(each1)) {
                    if (each1 == null) {
                        throw new NullPointerException();
                    }
                    result[0] = each1;
                    return true;
                }
                return false;
            });
        });
        return Optional.ofNullable(result[0]);
    }

    @Override
    public boolean anySatisfy(Predicate<? super V> predicate) {
        return this.iterable.anySatisfy((CharPredicate & Serializable)each -> Iterate.anySatisfy((Iterable)this.function.valueOf(each), predicate));
    }

    @Override
    public <P> boolean anySatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.anySatisfy(Predicates.bind(predicate, parameter));
    }

    @Override
    public boolean allSatisfy(Predicate<? super V> predicate) {
        return this.iterable.allSatisfy((CharPredicate & Serializable)each -> Iterate.allSatisfy((Iterable)this.function.valueOf(each), predicate));
    }

    @Override
    public <P> boolean allSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.allSatisfy(Predicates.bind(predicate, parameter));
    }

    @Override
    public boolean noneSatisfy(Predicate<? super V> predicate) {
        return this.iterable.noneSatisfy((CharPredicate & Serializable)each -> Iterate.anySatisfy((Iterable)this.function.valueOf(each), predicate));
    }

    @Override
    public <P> boolean noneSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.noneSatisfy(Predicates.bind(predicate, parameter));
    }

    private final class FlatCollectCharIterator<V>
    implements Iterator<V> {
        private final CharIterator iterator;
        private final CharToObjectFunction<? extends Iterable<V>> function;
        private Iterator<V> innerIterator = EmptyIterator.getInstance();

        public FlatCollectCharIterator(CharIterable iterable, CharToObjectFunction<? extends Iterable<V>> newFunction) {
            this(iterable.charIterator(), newFunction);
        }

        public FlatCollectCharIterator(CharIterator newIterator, CharToObjectFunction<? extends Iterable<V>> newFunction) {
            this.iterator = newIterator;
            this.function = newFunction;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove from a flatCollectChar iterator");
        }

        @Override
        public boolean hasNext() {
            while (!this.innerIterator.hasNext()) {
                if (!this.iterator.hasNext()) {
                    return false;
                }
                this.innerIterator = ((Iterable)this.function.valueOf(this.iterator.next())).iterator();
            }
            return true;
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.innerIterator.next();
        }
    }
}

