/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.wires.input;

import com.swirlds.component.framework.model.TraceableWiringModel;
import com.swirlds.component.framework.schedulers.TaskScheduler;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerType;
import com.swirlds.component.framework.wires.input.Bindable;
import com.swirlds.component.framework.wires.input.InputWire;
import com.swirlds.component.framework.wires.input.TaskSchedulerInput;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class BindableInputWire<IN, OUT>
extends InputWire<IN>
implements Bindable<IN, OUT> {
    private final TaskSchedulerInput<OUT> taskSchedulerInput;
    private final String taskSchedulerName;
    private final TraceableWiringModel model;
    private final Supplier<Boolean> currentlySquelching;
    private final boolean noOp;

    public BindableInputWire(@NonNull TraceableWiringModel model, @NonNull TaskScheduler<OUT> taskScheduler, @NonNull String name) {
        super(taskScheduler, name);
        this.model = Objects.requireNonNull(model);
        this.taskSchedulerInput = Objects.requireNonNull(taskScheduler);
        this.taskSchedulerName = taskScheduler.getName();
        this.currentlySquelching = taskScheduler::currentlySquelching;
        boolean bl = this.noOp = taskScheduler.getType() == TaskSchedulerType.NO_OP;
        if (this.noOp) {
            return;
        }
        model.registerInputWireCreation(this.taskSchedulerName, name);
    }

    @Override
    public void bindConsumer(@NonNull Consumer<IN> handler) {
        Objects.requireNonNull(handler);
        if (this.noOp) {
            return;
        }
        this.setHandler(i -> {
            if (this.currentlySquelching.get().booleanValue()) {
                return;
            }
            handler.accept(i);
        });
        this.model.registerInputWireBinding(this.taskSchedulerName, this.getName());
    }

    @Override
    public void bind(@NonNull Function<IN, OUT> handler) {
        Objects.requireNonNull(handler);
        if (this.noOp) {
            return;
        }
        this.setHandler(i -> {
            if (this.currentlySquelching.get().booleanValue()) {
                return;
            }
            Object output = handler.apply(i);
            if (output != null) {
                this.taskSchedulerInput.forward(output);
            }
        });
        this.model.registerInputWireBinding(this.taskSchedulerName, this.getName());
    }
}

