/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.Setting;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class SettingJsonCodec
implements JsonCodec<Setting> {
    @NonNull
    public Setting parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            String temp_name = "";
            String temp_value = "";
            Bytes temp_data = Bytes.EMPTY;
            block12: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "name": {
                        temp_name = JsonTools.unescape((String)JsonTools.checkSize((String)"name", (String)kvPair.value().STRING().getText(), (int)maxSize));
                        continue block12;
                    }
                    case "value": {
                        temp_value = JsonTools.unescape((String)JsonTools.checkSize((String)"value", (String)kvPair.value().STRING().getText(), (int)maxSize));
                        continue block12;
                    }
                    case "data": {
                        temp_data = Bytes.fromBase64((String)JsonTools.checkSize((String)"data", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block12;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new Setting(temp_name, temp_value, temp_data);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull Setting data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.name() != null && !data.name().isEmpty()) {
            fieldLines.add(JsonTools.field((String)"name", (String)data.name()));
        }
        if (data.value() != null && !data.value().isEmpty()) {
            fieldLines.add(JsonTools.field((String)"value", (String)data.value()));
        }
        if (data.data() != Bytes.EMPTY && data.data() != null && data.data().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"data", (Bytes)data.data()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

