/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb.files;

import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.hedera.pbj.runtime.io.stream.ReadableStreamingData;
import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.merkledb.config.MerkleDbConfig;
import com.swirlds.merkledb.files.DataFileCommon;
import com.swirlds.merkledb.files.DataFileMetadata;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;

public final class DataFileIterator
implements AutoCloseable {
    private final BufferedInputStream inputStream;
    private final ReadableSequentialData in;
    private final DataFileMetadata metadata;
    private final Path path;
    private BufferedData dataItemBuffer;
    private long currentDataItem = -1L;
    private long currentDataItemFilePosition = 0L;
    private boolean closed = false;

    public DataFileIterator(MerkleDbConfig dbConfig, Path path, DataFileMetadata metadata) throws IOException {
        this.path = path;
        this.metadata = metadata;
        this.inputStream = new BufferedInputStream(Files.newInputStream(path, StandardOpenOption.READ), dbConfig.iteratorInputBufferBytes());
        this.in = new ReadableStreamingData((InputStream)this.inputStream);
        this.in.limit(Files.size(path));
    }

    public Path getPath() {
        return this.path;
    }

    public DataFileMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.dataItemBuffer = null;
            this.inputStream.close();
        }
    }

    public boolean next() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Cannot read from a closed iterator");
        }
        while (this.in.hasRemaining()) {
            this.currentDataItemFilePosition = this.in.position();
            int tag = this.in.readVarInt(false);
            int fieldNum = tag >> 3;
            if (fieldNum == DataFileCommon.FIELD_DATAFILE_ITEMS.number()) {
                int currentDataItemSize = this.in.readVarInt(false);
                this.dataItemBuffer = this.fillBuffer(currentDataItemSize);
                ++this.currentDataItem;
                return true;
            }
            if (fieldNum == DataFileCommon.FIELD_DATAFILE_METADATA.number()) {
                int metadataSize = this.in.readVarInt(false);
                this.in.skip((long)metadataSize);
                continue;
            }
            throw new IllegalArgumentException("Unknown data file field: " + fieldNum);
        }
        return false;
    }

    public BufferedData getDataItemData() {
        return this.dataItemBuffer;
    }

    public long getDataItemDataLocation() {
        return DataFileCommon.dataLocation(this.metadata.getIndex(), this.currentDataItemFilePosition);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("fileIndex", (Object)this.metadata.getIndex()).append("currentDataItemIndex", (Object)this.currentDataItem).append("currentDataItemByteOffset", (Object)this.currentDataItemFilePosition).append("fileName", (Object)this.path.getFileName()).append("metadata", (Object)this.metadata).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataFileIterator that = (DataFileIterator)o;
        return this.path.equals(that.getPath()) && this.metadata.equals(that.getMetadata());
    }

    public int hashCode() {
        return Objects.hash(this.path, this.metadata);
    }

    private BufferedData fillBuffer(int bytesToRead) throws IOException {
        if (bytesToRead <= 0) {
            throw new IOException("Malformed file [" + String.valueOf(this.path) + "], data item [" + this.currentDataItem + "], requested bytes [" + bytesToRead + "]");
        }
        if (this.dataItemBuffer == null || this.dataItemBuffer.capacity() < (long)bytesToRead) {
            this.dataItemBuffer = BufferedData.allocate((int)bytesToRead);
        }
        this.dataItemBuffer.position(0L);
        this.dataItemBuffer.limit((long)bytesToRead);
        long bytesRead = this.in.readBytes(this.dataItemBuffer);
        if (bytesRead != (long)bytesToRead) {
            throw new IOException("Couldn't read " + bytesToRead + " bytes, data item [" + this.currentDataItem + "], requested bytes [" + bytesToRead + "]");
        }
        this.dataItemBuffer.position(0L);
        return this.dataItemBuffer;
    }
}

