/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.test.fixtures;

import com.swirlds.state.spi.WritableQueueStateBase;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;

public class ListWritableQueueState<E>
extends WritableQueueStateBase<E> {
    private final Queue<E> backingStore;

    public ListWritableQueueState(int stateId, @NonNull String label, @NonNull Queue<E> backingStore) {
        super(stateId, Objects.requireNonNull(label));
        this.backingStore = Objects.requireNonNull(backingStore);
    }

    protected void addToDataSource(@NonNull E element) {
        this.backingStore.add(element);
    }

    protected void removeFromDataSource() {
        this.backingStore.remove();
    }

    @NonNull
    protected Iterator<E> iterateOnDataSource() {
        return this.backingStore.iterator();
    }

    @NonNull
    public static <E> Builder<E> builder(int stateId, @NonNull String label) {
        return new Builder(stateId, label);
    }

    public static final class Builder<E> {
        private final int stateId;
        private final String label;
        private final Queue<E> backingStore = new LinkedList();

        Builder(int stateId, @NonNull String label) {
            this.stateId = stateId;
            this.label = Objects.requireNonNull(label);
        }

        @NonNull
        public Builder<E> value(@NonNull E element) {
            this.backingStore.add(element);
            return this;
        }

        @NonNull
        public ListWritableQueueState<E> build() {
            return new ListWritableQueueState<E>(this.stateId, this.label, new LinkedList<E>(this.backingStore));
        }
    }
}

