/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.spi;

import com.swirlds.state.spi.ReadableKVState;
import com.swirlds.state.spi.ReadableQueueState;
import com.swirlds.state.spi.ReadableSingletonState;
import com.swirlds.state.spi.ReadableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class FilteredReadableStates
implements ReadableStates {
    private final ReadableStates delegate;
    private final Set<String> stateKeys;

    public FilteredReadableStates(@NonNull ReadableStates delegate, @NonNull Set<String> stateKeys) {
        this.delegate = Objects.requireNonNull(delegate);
        this.stateKeys = stateKeys.stream().filter(delegate::contains).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    @NonNull
    public <K, V> ReadableKVState<K, V> get(@NonNull String stateKey) {
        Objects.requireNonNull(stateKey);
        if (!this.contains(stateKey)) {
            throw new IllegalArgumentException("Could not find k/v state " + stateKey);
        }
        return this.delegate.get(stateKey);
    }

    @Override
    @NonNull
    public <T> ReadableSingletonState<T> getSingleton(@NonNull String stateKey) {
        Objects.requireNonNull(stateKey);
        if (!this.contains(stateKey)) {
            throw new IllegalArgumentException("Could not find singleton state " + stateKey);
        }
        return this.delegate.getSingleton(stateKey);
    }

    @Override
    @NonNull
    public <E> ReadableQueueState<E> getQueue(@NonNull String stateKey) {
        Objects.requireNonNull(stateKey);
        if (!this.contains(stateKey)) {
            throw new IllegalArgumentException("Could not find queue state " + stateKey);
        }
        return this.delegate.getQueue(stateKey);
    }

    @Override
    public boolean contains(@NonNull String stateKey) {
        return this.stateKeys.contains(stateKey);
    }

    @Override
    @NonNull
    public Set<String> stateKeys() {
        return this.stateKeys;
    }
}

