/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.state.primitives.ProtoBytes;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.node.app.hapi.utils.EntityType;
import com.hedera.node.app.service.token.AliasUtils;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.spi.ids.ReadableEntityCounters;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.spi.ReadableKVState;
import com.swirlds.state.spi.ReadableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public class ReadableAccountStoreImpl
implements ReadableAccountStore {
    private final ReadableKVState<AccountID, Account> accountState;
    private final ReadableKVState<ProtoBytes, AccountID> aliases;
    private final ReadableEntityCounters entityCounters;

    public ReadableAccountStoreImpl(@NonNull ReadableStates states, ReadableEntityCounters entityCounters) {
        this.accountState = states.get("ACCOUNTS");
        this.aliases = states.get("ALIASES");
        this.entityCounters = Objects.requireNonNull(entityCounters);
    }

    protected <T extends ReadableKVState<AccountID, Account>> T accountState() {
        return (T)this.accountState;
    }

    protected <T extends ReadableKVState<ProtoBytes, AccountID>> T aliases() {
        return (T)this.aliases;
    }

    @Nullable
    public Account getAccountById(@NonNull AccountID accountID) {
        return this.getAccountLeaf(accountID);
    }

    @Nullable
    public AccountID getAccountIDByAlias(long shardNum, long realmNum, @NonNull Bytes alias) {
        return this.lookupAlias(shardNum, realmNum, alias);
    }

    public boolean containsAlias(long shardNum, long realmNum, @NonNull Bytes alias) {
        return this.getAccountIDByAlias(shardNum, realmNum, alias) != null;
    }

    public boolean contains(@NonNull AccountID accountID) {
        return this.accountState().contains((Object)accountID);
    }

    @Nullable
    protected Account getAccountLeaf(@NonNull AccountID id) {
        Objects.requireNonNull(id);
        OneOf accountOneOf = id.account();
        return accountOneOf.kind() == AccountID.AccountOneOfType.ACCOUNT_NUM ? (Account)this.accountState.get((Object)id) : null;
    }

    @Nullable
    public Account getAliasedAccountById(@NonNull AccountID accountID) {
        return this.getAliasedAccountLeaf(accountID);
    }

    @Nullable
    protected Account getAliasedAccountLeaf(@NonNull AccountID id) {
        Objects.requireNonNull(id);
        AccountID accountId = this.lookupAliasedAccountId(id);
        return accountId == null ? null : (Account)this.accountState.get((Object)accountId);
    }

    public long getNumberOfAccounts() {
        return this.entityCounters.getCounterFor(EntityType.ACCOUNT);
    }

    public long sizeOfAliasesState() {
        return this.entityCounters.getCounterFor(EntityType.ALIAS);
    }

    @Nullable
    protected AccountID lookupAliasedAccountId(@NonNull AccountID id) {
        OneOf accountOneOf = id.account();
        return switch ((AccountID.AccountOneOfType)accountOneOf.kind()) {
            default -> throw new MatchException(null, null);
            case AccountID.AccountOneOfType.ACCOUNT_NUM -> id;
            case AccountID.AccountOneOfType.ALIAS -> {
                Bytes alias = (Bytes)accountOneOf.as();
                yield this.lookupAlias(id.shardNum(), id.realmNum(), alias);
            }
            case AccountID.AccountOneOfType.UNSET -> null;
        };
    }

    @Nullable
    private AccountID lookupAlias(long shardNum, long realmNum, Bytes alias) {
        if (AliasUtils.isEntityNumAlias((Bytes)alias)) {
            return AccountID.newBuilder().shardNum(shardNum).realmNum(realmNum).accountNum(AliasUtils.extractIdFromAddressAlias((Bytes)alias).longValue()).build();
        }
        AccountID found = (AccountID)this.aliases.get((Object)new ProtoBytes(alias));
        if (found != null) {
            return found;
        }
        return (AccountID)this.aliases.get((Object)new ProtoBytes(AliasUtils.extractEvmAddress((Key)AliasUtils.asKeyFromAliasOrElse((Bytes)alias, null))));
    }

    public long sizeOfAccountState() {
        return this.entityCounters.getCounterFor(EntityType.ACCOUNT);
    }

    public void warm(@NonNull AccountID accountID) {
        AccountID unaliasedId = this.lookupAliasedAccountId(accountID);
        if (unaliasedId != null) {
            this.accountState.warm((Object)unaliasedId);
        }
    }
}

