/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers.transfer.customfees;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.transaction.AssessedCustomFee;
import com.hedera.hapi.node.transaction.CustomFee;
import com.hedera.hapi.node.transaction.FixedCustomFee;
import com.hedera.hapi.node.transaction.FixedFee;
import com.hedera.node.app.service.token.impl.handlers.transfer.customfees.AdjustmentUtils;
import com.hedera.node.app.service.token.impl.handlers.transfer.customfees.AssessmentResult;
import com.hedera.node.app.service.token.impl.handlers.transfer.customfees.CustomFeeExemptions;
import edu.umd.cs.findbugs.annotations.NonNull;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CustomFixedFeeAssessor {
    @Inject
    public CustomFixedFeeAssessor() {
    }

    public void assessFixedFees(@NonNull Token token, @NonNull AccountID sender, AssessmentResult result) {
        for (CustomFee fee : token.customFees()) {
            AccountID collector;
            if (!((CustomFee.FeeOneOfType)fee.fee().kind()).equals((Object)CustomFee.FeeOneOfType.FIXED_FEE) || sender.equals((Object)(collector = fee.feeCollectorAccountId()))) continue;
            this.assessFixedFee(token, sender, fee, result);
        }
    }

    public void assessFixedFee(Token token, AccountID sender, CustomFee fee, AssessmentResult result) {
        if (CustomFeeExemptions.isPayerExempt(token, fee, sender)) {
            return;
        }
        FixedFee fixedFeeSpec = fee.fixedFeeOrThrow();
        if (!fixedFeeSpec.hasDenominatingTokenId()) {
            this.assessHbarFees(sender, fee, result, true);
        } else {
            this.assessHTSFees(sender, token, fee, result, true);
        }
    }

    public void setTransactionFeesAsAssessed(AccountID payer, FixedCustomFee fixedCustomFee, AssessmentResult result) {
        if (fixedCustomFee.hasFixedFee() && fixedCustomFee.hasFeeCollectorAccountId()) {
            FixedFee fixedFee = fixedCustomFee.fixedFee();
            CustomFee customFee = CustomFee.newBuilder().feeCollectorAccountId(fixedCustomFee.feeCollectorAccountId()).fixedFee(fixedFee).build();
            if (fixedFee.hasDenominatingTokenId()) {
                Token token = Token.newBuilder().tokenId(fixedFee.denominatingTokenId()).build();
                this.assessHTSFees(payer, token, customFee, result, false);
            } else {
                this.assessHbarFees(payer, customFee, result, false);
            }
        }
    }

    private void assessHbarFees(@NonNull AccountID sender, @NonNull CustomFee hbarFee, @NonNull AssessmentResult result, boolean doAdjustments) {
        AccountID collector = hbarFee.feeCollectorAccountId();
        FixedFee fixedSpec = hbarFee.fixedFee();
        long amount = fixedSpec.amount();
        if (doAdjustments) {
            AdjustmentUtils.adjustHbarFees(result, sender, hbarFee);
        }
        result.addAssessedCustomFee(AssessedCustomFee.newBuilder().effectivePayerAccountId(new AccountID[]{sender}).amount(amount).feeCollectorAccountId(collector).build());
    }

    private void assessHTSFees(@NonNull AccountID sender, @NonNull Token token, @NonNull CustomFee htsFee, @NonNull AssessmentResult result, boolean doAdjustments) {
        AccountID collector = htsFee.feeCollectorAccountIdOrThrow();
        FixedFee fixedFeeSpec = htsFee.fixedFeeOrThrow();
        long amount = fixedFeeSpec.amount();
        TokenID denominatingToken = fixedFeeSpec.denominatingTokenIdOrThrow();
        if (doAdjustments) {
            AdjustmentUtils.adjustHtsFees(result, sender, collector, token, amount, denominatingToken);
        }
        result.addAssessedCustomFee(AssessedCustomFee.newBuilder().effectivePayerAccountId(new AccountID[]{sender}).amount(amount).feeCollectorAccountId(collector).tokenId(fixedFeeSpec.denominatingTokenId()).build());
    }
}

