/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.model.sequence.map;

import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.hiero.base.Clearable;
import org.hiero.consensus.model.sequence.Shiftable;

public interface SequenceMap<K, V>
extends Clearable,
Shiftable {
    public V get(K var1);

    public boolean containsKey(K var1);

    public V computeIfAbsent(K var1, Function<? super K, ? extends V> var2);

    public boolean putIfAbsent(K var1, V var2);

    public V put(K var1, V var2);

    public V remove(K var1);

    default public void removeValuesWithSequenceNumber(long sequenceNumber) {
        this.removeValuesWithSequenceNumber(sequenceNumber, null);
    }

    public void removeValuesWithSequenceNumber(long var1, BiConsumer<K, V> var3);

    public List<K> getKeysWithSequenceNumber(long var1);

    public List<Map.Entry<K, V>> getEntriesWithSequenceNumber(long var1);

    @Override
    default public void shiftWindow(long firstSequenceNumberInWindow) {
        this.shiftWindow(firstSequenceNumberInWindow, null);
    }

    public void shiftWindow(long var1, BiConsumer<K, V> var3);

    public int getSize();

    public long getFirstSequenceNumberInWindow();

    default public long getLastSequenceNumberInWindow() {
        return this.getFirstSequenceNumberInWindow() + (long)this.getSequenceNumberCapacity() - 1L;
    }

    public int getSequenceNumberCapacity();
}

