/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle.disk;

import com.hedera.hapi.platform.state.QueueState;
import com.hedera.hapi.platform.state.StateValue;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.merkle.StateUtils;
import com.swirlds.state.merkle.logging.StateLogger;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public final class OnDiskQueueHelper<E> {
    @NonNull
    private final String serviceName;
    @NonNull
    private final String stateKey;
    @NonNull
    private final VirtualMap virtualMap;
    private final QueueIterator EMPTY_ITERATOR = new QueueIterator(0L, 0L);

    public OnDiskQueueHelper(@NonNull String serviceName, @NonNull String stateKey, @NonNull VirtualMap virtualMap) {
        this.serviceName = Objects.requireNonNull(serviceName);
        this.stateKey = Objects.requireNonNull(stateKey);
        this.virtualMap = Objects.requireNonNull(virtualMap);
    }

    @NonNull
    public Iterator<E> iterateOnDataSource() {
        QueueState state = this.getState();
        if (state == null) {
            return this.EMPTY_ITERATOR;
        }
        QueueIterator it = new QueueIterator(state.head(), state.tail());
        StateLogger.logQueueIterate(StateUtils.computeLabel(this.serviceName, this.stateKey), state.tail() - state.head(), it);
        it.reset();
        return it;
    }

    @NonNull
    public E getFromStore(long index) {
        Object value;
        StateValue stateValue = (StateValue)this.virtualMap.get(StateUtils.getStateKeyForQueue(this.serviceName, this.stateKey, index), StateValue.PROTOBUF);
        Object object = value = stateValue != null ? stateValue.value().as() : null;
        if (value == null) {
            throw new IllegalStateException("Can't find queue element at index " + index + " in the store");
        }
        return (E)value;
    }

    public QueueState getState() {
        StateValue stateValue = (StateValue)this.virtualMap.get(StateUtils.getStateKeyForSingleton(this.serviceName, this.stateKey), StateValue.PROTOBUF);
        return stateValue != null ? (QueueState)stateValue.value().as() : null;
    }

    public void updateState(@NonNull QueueState state) {
        Bytes keyBytes = StateUtils.getStateKeyForSingleton(this.serviceName, this.stateKey);
        StateValue queueStateValue = StateUtils.getQueueStateValue(state);
        this.virtualMap.put(keyBytes, (Object)queueStateValue, StateValue.PROTOBUF);
    }

    public static boolean isEmpty(@NonNull QueueState state) {
        return state.head() == state.tail();
    }

    private class QueueIterator
    implements Iterator<E> {
        private final long start;
        private final long limit;
        private long current;

        public QueueIterator(long start, long limit) {
            this.start = start;
            this.limit = limit;
            this.reset();
        }

        @Override
        public boolean hasNext() {
            return this.current < this.limit;
        }

        @Override
        public E next() {
            if (this.current == this.limit) {
                throw new NoSuchElementException();
            }
            try {
                return OnDiskQueueHelper.this.getFromStore(this.current++);
            }
            catch (IllegalStateException e) {
                throw new ConcurrentModificationException(e);
            }
        }

        void reset() {
            this.current = this.start;
        }
    }
}

