/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.schedulers.internal;

import com.swirlds.component.framework.counters.ObjectCounter;
import com.swirlds.component.framework.model.TraceableWiringModel;
import com.swirlds.component.framework.schedulers.TaskScheduler;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerType;
import com.swirlds.component.framework.schedulers.internal.ConcurrentTask;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;

public class ConcurrentTaskScheduler<OUT>
extends TaskScheduler<OUT> {
    private final ObjectCounter onRamp;
    private final ObjectCounter offRamp;
    private final ForkJoinPool pool;
    private final long capacity;

    public ConcurrentTaskScheduler(@NonNull TraceableWiringModel model, @NonNull String name, @NonNull ForkJoinPool pool, @NonNull Thread.UncaughtExceptionHandler uncaughtExceptionHandler, @NonNull ObjectCounter onRamp, @NonNull ObjectCounter offRamp, long capacity, boolean flushEnabled, boolean squelchingEnabled, boolean insertionIsBlocking) {
        super(model, name, TaskSchedulerType.CONCURRENT, uncaughtExceptionHandler, flushEnabled, squelchingEnabled, insertionIsBlocking);
        this.pool = Objects.requireNonNull(pool);
        this.onRamp = Objects.requireNonNull(onRamp);
        this.offRamp = Objects.requireNonNull(offRamp);
        this.capacity = capacity;
    }

    @Override
    protected void put(@NonNull Consumer<Object> handler, @NonNull Object data) {
        this.onRamp.onRamp();
        new ConcurrentTask(this.pool, this.offRamp, this.getUncaughtExceptionHandler(), handler, data).send();
    }

    @Override
    protected boolean offer(@NonNull Consumer<Object> handler, @NonNull Object data) {
        boolean accepted = this.onRamp.attemptOnRamp();
        if (accepted) {
            new ConcurrentTask(this.pool, this.offRamp, this.getUncaughtExceptionHandler(), handler, data).send();
        }
        return accepted;
    }

    @Override
    protected void inject(@NonNull Consumer<Object> handler, @NonNull Object data) {
        this.onRamp.forceOnRamp();
        new ConcurrentTask(this.pool, this.offRamp, this.getUncaughtExceptionHandler(), handler, data).send();
    }

    @Override
    public long getUnprocessedTaskCount() {
        return this.onRamp.getCount();
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public void flush() {
        this.throwIfFlushDisabled();
        this.onRamp.waitUntilEmpty();
    }
}

