/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.cli;

import com.swirlds.cli.commands.StateCommand;
import com.swirlds.cli.utility.AbstractCommand;
import com.swirlds.cli.utility.SubcommandOf;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.platform.config.DefaultConfiguration;
import com.swirlds.platform.consensus.SyntheticSnapshot;
import com.swirlds.platform.state.MerkleNodeState;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.state.signed.ReservedSignedState;
import com.swirlds.platform.state.snapshot.DeserializedSignedState;
import com.swirlds.platform.state.snapshot.SavedStateMetadata;
import com.swirlds.platform.state.snapshot.SignedStateFileReader;
import com.swirlds.platform.state.snapshot.SignedStateFileWriter;
import com.swirlds.platform.util.BootstrapUtils;
import com.swirlds.state.spi.CommittableWritableStates;
import com.swirlds.state.spi.WritableStates;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import org.hiero.consensus.roster.WritableRosterStore;
import picocli.CommandLine;

@CommandLine.Command(name="genesis", mixinStandardHelpOptions=true, description={"Edit an existing state by replacing the platform state with a new genesis state."})
@SubcommandOf(value=StateCommand.class)
public class GenesisPlatformStateCommand
extends AbstractCommand {
    private Path statePath;
    private Path outputDir;

    @CommandLine.Parameters(description={"The path to the state to edit"}, index="0")
    private void setStatePath(Path statePath) {
        this.statePath = this.pathMustExist(statePath.toAbsolutePath());
    }

    @CommandLine.Parameters(description={"The path to the output directory"}, index="1")
    private void setOutputDir(Path outputDir) {
        this.outputDir = this.dirMustExist(outputDir.toAbsolutePath());
    }

    public Integer call() throws IOException, ExecutionException, InterruptedException {
        Configuration configuration = DefaultConfiguration.buildBasicConfiguration(ConfigurationBuilder.create());
        BootstrapUtils.setupConstructableRegistry();
        PlatformContext platformContext = PlatformContext.create((Configuration)configuration);
        System.out.printf("Reading from %s %n", this.statePath.toAbsolutePath());
        PlatformStateFacade stateFacade = PlatformStateFacade.DEFAULT_PLATFORM_STATE_FACADE;
        DeserializedSignedState deserializedSignedState = SignedStateFileReader.readStateFile(this.statePath, virtualMap -> {
            throw new UnsupportedOperationException();
        }, stateFacade, platformContext);
        try (ReservedSignedState reservedSignedState = deserializedSignedState.reservedSignedState();){
            stateFacade.bulkUpdateOf(reservedSignedState.get().getState(), v -> {
                System.out.printf("Replacing platform data %n", new Object[0]);
                v.setRound(0L);
                v.setSnapshot(SyntheticSnapshot.getGenesisSnapshot());
            });
            System.out.printf("Resetting the RosterService state %n", new Object[0]);
            MerkleNodeState state = reservedSignedState.get().getState();
            WritableStates writableStates = state.getWritableStates("RosterService");
            WritableRosterStore writableRosterStore = new WritableRosterStore(writableStates);
            writableRosterStore.resetRosters();
            ((CommittableWritableStates)writableStates).commit();
            System.out.printf("Hashing state %n", new Object[0]);
            platformContext.getMerkleCryptography().digestTreeAsync(reservedSignedState.get().getState().getRoot()).get();
            System.out.printf("Writing modified state to %s %n", this.outputDir.toAbsolutePath());
            SignedStateFileWriter.writeSignedStateFilesToDirectory(platformContext, SavedStateMetadata.NO_NODE_ID, this.outputDir, reservedSignedState.get(), stateFacade);
        }
        return 0;
    }
}

