/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.health.entropy;

import com.swirlds.platform.health.entropy.SecureRandomSupplier;
import java.security.SecureRandom;

public record EntropySource(String description, SecureRandomSupplier randomSupplier) {
    public static EntropySource systemDefault() {
        return new EntropySource("System Default", SecureRandom::new);
    }

    public static EntropySource of(String algorithm, String provider) {
        return new EntropySource(algorithm + ":" + provider, () -> SecureRandom.getInstance(algorithm, provider));
    }

    public static EntropySource strong() {
        return new EntropySource("Strong Instance", SecureRandom::getInstanceStrong);
    }
}

