/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.file.codec;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.state.file.File;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class FileJsonCodec
implements JsonCodec<File> {
    @NonNull
    public File parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            FileID temp_file_id = null;
            long temp_expiration_second = 0L;
            KeyList temp_keys = null;
            Bytes temp_contents = Bytes.EMPTY;
            String temp_memo = "";
            boolean temp_deleted = false;
            long temp_pre_system_delete_expiration_second = 0L;
            block20: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "fileId": {
                        temp_file_id = (FileID)FileID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block20;
                    }
                    case "expirationSecond": {
                        temp_expiration_second = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block20;
                    }
                    case "keys": {
                        temp_keys = (KeyList)KeyList.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block20;
                    }
                    case "contents": {
                        temp_contents = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block20;
                    }
                    case "memo": {
                        temp_memo = JsonTools.unescape((String)kvPair.value().STRING().getText());
                        continue block20;
                    }
                    case "deleted": {
                        temp_deleted = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                        continue block20;
                    }
                    case "preSystemDeleteExpirationSecond": {
                        temp_pre_system_delete_expiration_second = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block20;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new File(temp_file_id, temp_expiration_second, temp_keys, temp_contents, temp_memo, temp_deleted, temp_pre_system_delete_expiration_second);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull File data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.fileId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"fileId", FileID.JSON, (Object)data.fileId()));
        }
        if (data.expirationSecond() != 0L) {
            fieldLines.add(JsonTools.field((String)"expirationSecond", (long)data.expirationSecond()));
        }
        if (data.keys() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"keys", KeyList.JSON, (Object)data.keys()));
        }
        if (data.contents() != Bytes.EMPTY && data.contents() != null && data.contents().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"contents", (Bytes)data.contents()));
        }
        if (data.memo() != "") {
            fieldLines.add(JsonTools.field((String)"memo", (String)data.memo()));
        }
        if (data.deleted()) {
            fieldLines.add(JsonTools.field((String)"deleted", (boolean)data.deleted()));
        }
        if (data.preSystemDeleteExpirationSecond() != 0L) {
            fieldLines.add(JsonTools.field((String)"preSystemDeleteExpirationSecond", (long)data.preSystemDeleteExpirationSecond()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

