/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.grpc;

import io.grpc.CallCredentials;
import io.grpc.ClientInterceptor;
import io.grpc.MethodDescriptor;
import io.helidon.grpc.core.MarshallerSupplier;
import io.helidon.grpc.core.MethodHandler;
import io.helidon.grpc.core.WeightedBag;
import java.util.Arrays;
import java.util.Objects;

public final class GrpcClientMethodDescriptor {
    private final String name;
    private final MethodDescriptor<?, ?> descriptor;
    private WeightedBag<ClientInterceptor> interceptors;
    private final CallCredentials callCredentials;
    private final MethodHandler<?, ?> methodHandler;

    private GrpcClientMethodDescriptor(String name, MethodDescriptor<?, ?> descriptor, WeightedBag<ClientInterceptor> interceptors, CallCredentials callCredentials, MethodHandler<?, ?> methodHandler) {
        this.name = name;
        this.descriptor = descriptor;
        this.interceptors = interceptors;
        this.callCredentials = callCredentials;
        this.methodHandler = methodHandler;
    }

    public static Builder builder(String serviceName, String name, MethodDescriptor.Builder<?, ?> descriptor) {
        return new Builder(serviceName, name, descriptor);
    }

    public static GrpcClientMethodDescriptor create(String serviceName, String name, MethodDescriptor.Builder<?, ?> descriptor) {
        return GrpcClientMethodDescriptor.builder(serviceName, name, descriptor).build();
    }

    public static Builder unary(String serviceName, String name) {
        return GrpcClientMethodDescriptor.builder(serviceName, name, MethodDescriptor.MethodType.UNARY);
    }

    public static Builder clientStreaming(String serviceName, String name) {
        return GrpcClientMethodDescriptor.builder(serviceName, name, MethodDescriptor.MethodType.CLIENT_STREAMING);
    }

    public static Builder serverStreaming(String serviceName, String name) {
        return GrpcClientMethodDescriptor.builder(serviceName, name, MethodDescriptor.MethodType.SERVER_STREAMING);
    }

    public static Builder bidirectional(String serviceName, String name) {
        return GrpcClientMethodDescriptor.builder(serviceName, name, MethodDescriptor.MethodType.BIDI_STREAMING);
    }

    WeightedBag<ClientInterceptor> interceptors() {
        return this.interceptors.readOnly();
    }

    public CallCredentials callCredentials() {
        return this.callCredentials;
    }

    public static Builder builder(String serviceName, String name, MethodDescriptor.MethodType methodType) {
        MethodDescriptor.Builder builder = MethodDescriptor.newBuilder().setFullMethodName(serviceName + "/" + name).setType(methodType);
        return ((Builder)new Builder(serviceName, name, builder).requestType((Class)Object.class)).responseType((Class)Object.class);
    }

    public String name() {
        return this.name;
    }

    public <ReqT, RespT> MethodDescriptor<ReqT, RespT> descriptor() {
        return this.descriptor;
    }

    public MethodDescriptor.MethodType type() {
        return this.descriptor.getType();
    }

    public MethodHandler<?, ?> methodHandler() {
        return this.methodHandler;
    }

    public static class Builder
    implements Rules,
    io.helidon.common.Builder<Builder, GrpcClientMethodDescriptor> {
        private String name;
        private final MethodDescriptor.Builder<?, ?> descriptor;
        private Class<?> requestType;
        private Class<?> responseType;
        private final WeightedBag<ClientInterceptor> interceptors = WeightedBag.create((double)1000.0);
        private MarshallerSupplier defaultMarshallerSupplier = MarshallerSupplier.create();
        private MarshallerSupplier marshallerSupplier;
        private CallCredentials callCredentials;
        private MethodHandler<?, ?> methodHandler;

        Builder(String serviceName, String name, MethodDescriptor.Builder<?, ?> descriptor) {
            this.name = name;
            this.descriptor = descriptor.setFullMethodName(serviceName + "/" + name);
        }

        @Override
        public Builder requestType(Class<?> type) {
            this.requestType = type;
            return this;
        }

        @Override
        public Builder responseType(Class<?> type) {
            this.responseType = type;
            return this;
        }

        @Override
        public Builder intercept(ClientInterceptor ... interceptors) {
            this.interceptors.addAll(Arrays.asList(interceptors));
            return this;
        }

        @Override
        public Builder intercept(double weight, ClientInterceptor ... interceptors) {
            this.interceptors.addAll(Arrays.asList(interceptors), weight);
            return this;
        }

        @Override
        public Builder marshallerSupplier(MarshallerSupplier supplier) {
            this.marshallerSupplier = supplier;
            return this;
        }

        Builder defaultMarshallerSupplier(MarshallerSupplier supplier) {
            this.defaultMarshallerSupplier = Objects.requireNonNullElseGet(supplier, MarshallerSupplier::create);
            return this;
        }

        @Override
        public Builder methodHandler(MethodHandler<?, ?> methodHandler) {
            this.methodHandler = methodHandler;
            return this;
        }

        Builder fullName(String fullName) {
            this.descriptor.setFullMethodName(fullName);
            this.name = fullName.substring(fullName.lastIndexOf(47) + 1);
            return this;
        }

        @Override
        public Rules callCredentials(CallCredentials callCredentials) {
            this.callCredentials = callCredentials;
            return this;
        }

        public GrpcClientMethodDescriptor build() {
            MarshallerSupplier supplier = this.marshallerSupplier;
            if (supplier == null) {
                supplier = this.defaultMarshallerSupplier;
            }
            if (this.requestType != null) {
                this.descriptor.setRequestMarshaller(supplier.get(this.requestType));
            }
            if (this.responseType != null) {
                this.descriptor.setResponseMarshaller(supplier.get(this.responseType));
            }
            return new GrpcClientMethodDescriptor(this.name, this.descriptor.build(), this.interceptors, this.callCredentials, this.methodHandler);
        }
    }

    public static interface Rules {
        public Rules requestType(Class<?> var1);

        public Rules responseType(Class<?> var1);

        public Rules intercept(ClientInterceptor ... var1);

        public Rules intercept(double var1, ClientInterceptor ... var3);

        public Rules marshallerSupplier(MarshallerSupplier var1);

        public Rules callCredentials(CallCredentials var1);

        public Rules methodHandler(MethodHandler<?, ?> var1);
    }
}

