/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.operations;

import com.hedera.node.app.service.contract.impl.exec.AddressChecks;
import com.hedera.node.app.service.contract.impl.exec.FeatureFlags;
import com.hedera.node.app.service.contract.impl.exec.failure.CustomExceptionalHaltReason;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import com.hedera.node.app.service.contract.impl.exec.utils.OperationUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.internal.UnderflowException;
import org.hyperledger.besu.evm.operation.Operation;

public interface BasicCustomCallOperation {
    public static final Operation.OperationResult UNDERFLOW_RESPONSE = new Operation.OperationResult(0L, ExceptionalHaltReason.INSUFFICIENT_STACK_ITEMS);

    public AddressChecks addressChecks();

    public FeatureFlags featureFlags();

    public Address to(@NonNull MessageFrame var1);

    public long cost(@NonNull MessageFrame var1);

    public Operation.OperationResult executeUnchecked(@NonNull MessageFrame var1, @NonNull EVM var2);

    default public Operation.OperationResult executeChecked(@NonNull MessageFrame frame, @NonNull EVM evm) {
        Objects.requireNonNull(evm);
        Objects.requireNonNull(frame);
        try {
            long cost = this.cost(frame);
            if (OperationUtils.isDeficientGas(frame, cost)) {
                return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
            }
            Address address = this.to(frame);
            if (FrameUtils.contractRequired(frame, address, this.featureFlags()) && this.addressChecks().isNeitherSystemNorPresent(address, frame)) {
                return new Operation.OperationResult(this.cost(frame), (ExceptionalHaltReason)CustomExceptionalHaltReason.INVALID_SOLIDITY_ADDRESS);
            }
            return this.executeUnchecked(frame, evm);
        }
        catch (UnderflowException ignore) {
            return UNDERFLOW_RESPONSE;
        }
    }
}

