/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.scheduled.SchedulableTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.failure.CustomExceptionalHaltReason;
import com.hedera.node.app.service.contract.impl.exec.gas.DispatchGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.scope.VerificationStrategy;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.ReturnTypes;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import com.hedera.node.app.service.contract.impl.exec.utils.SchedulingUtility;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.app.service.contract.impl.records.ContractCallStreamBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.Function;
import org.hyperledger.besu.evm.frame.MessageFrame;

public class DispatchForResponseCodeHtsCall
extends AbstractCall {
    private static final FailureCustomizer STANDARD_FAILURE_CUSTOMIZER = (body, code, enhancement) -> ReturnTypes.standardized(code);
    private final AccountID senderId;
    @Nullable
    private final TransactionBody syntheticBody;
    private final OutputFn outputFn;
    private final FailureCustomizer failureCustomizer;
    private final VerificationStrategy verificationStrategy;
    private final DispatchGasCalculator dispatchGasCalculator;

    public DispatchForResponseCodeHtsCall(@NonNull HtsCallAttempt attempt, @Nullable TransactionBody syntheticBody, @NonNull DispatchGasCalculator dispatchGasCalculator) {
        this(attempt.enhancement(), attempt.systemContractGasCalculator(), attempt.addressIdConverter().convertSender(attempt.senderAddress()), syntheticBody, attempt.defaultVerificationStrategy(), dispatchGasCalculator, STANDARD_FAILURE_CUSTOMIZER, OutputFn.STANDARD_OUTPUT_FN);
    }

    public DispatchForResponseCodeHtsCall(@NonNull HtsCallAttempt attempt, @Nullable TransactionBody syntheticBody, @NonNull DispatchGasCalculator dispatchGasCalculator, @NonNull FailureCustomizer failureCustomizer) {
        this(attempt.enhancement(), attempt.systemContractGasCalculator(), attempt.addressIdConverter().convertSender(attempt.senderAddress()), syntheticBody, attempt.defaultVerificationStrategy(), dispatchGasCalculator, failureCustomizer, OutputFn.STANDARD_OUTPUT_FN);
    }

    public DispatchForResponseCodeHtsCall(@NonNull HtsCallAttempt attempt, @Nullable TransactionBody syntheticBody, @NonNull DispatchGasCalculator dispatchGasCalculator, @NonNull OutputFn outputFn) {
        this(attempt.enhancement(), attempt.systemContractGasCalculator(), attempt.addressIdConverter().convertSender(attempt.senderAddress()), syntheticBody, attempt.defaultVerificationStrategy(), dispatchGasCalculator, STANDARD_FAILURE_CUSTOMIZER, outputFn);
    }

    public DispatchForResponseCodeHtsCall(@NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull SystemContractGasCalculator gasCalculator, @NonNull AccountID senderId, @Nullable TransactionBody syntheticBody, @NonNull VerificationStrategy verificationStrategy, @NonNull DispatchGasCalculator dispatchGasCalculator, @NonNull FailureCustomizer failureCustomizer, @NonNull OutputFn outputFn) {
        super(gasCalculator, enhancement, false);
        this.senderId = Objects.requireNonNull(senderId);
        this.outputFn = Objects.requireNonNull(outputFn);
        this.syntheticBody = syntheticBody;
        this.verificationStrategy = Objects.requireNonNull(verificationStrategy);
        this.dispatchGasCalculator = Objects.requireNonNull(dispatchGasCalculator);
        this.failureCustomizer = Objects.requireNonNull(failureCustomizer);
    }

    @Override
    @NonNull
    public Call.PricedResult execute(@NonNull MessageFrame frame) {
        if (this.syntheticBody == null) {
            return Call.PricedResult.gasOnly(FullResult.haltResult(CustomExceptionalHaltReason.ERROR_DECODING_PRECOMPILE_INPUT, FrameUtils.contractsConfigOf(frame).precompileHtsDefaultGasCost()), ResponseCodeEnum.INVALID_TRANSACTION_BODY, false);
        }
        ContractCallStreamBuilder recordBuilder = this.systemContractOperations().dispatch(this.syntheticBody, this.verificationStrategy, this.senderId, ContractCallStreamBuilder.class);
        long gasRequirement = this.dispatchGasCalculator.gasRequirement(this.syntheticBody, this.gasCalculator, this.enhancement, this.senderId);
        ResponseCodeEnum status = recordBuilder.status();
        if (status != ResponseCodeEnum.SUCCESS) {
            status = this.failureCustomizer.customize(this.syntheticBody, status, this.enhancement);
            recordBuilder.status(status);
        }
        return this.completionWith(gasRequirement, recordBuilder, (ByteBuffer)this.outputFn.apply(recordBuilder));
    }

    @Override
    @NonNull
    public SchedulableTransactionBody asSchedulableDispatchIn() {
        if (this.syntheticBody == null) {
            return super.asSchedulableDispatchIn();
        }
        return SchedulingUtility.ordinaryChildAsSchedulable(this.syntheticBody);
    }

    @FunctionalInterface
    public static interface FailureCustomizer {
        public static final FailureCustomizer NOOP_CUSTOMIZER = (body, code, enhancement) -> code;

        @NonNull
        public ResponseCodeEnum customize(@NonNull TransactionBody var1, @NonNull ResponseCodeEnum var2, @NonNull HederaWorldUpdater.Enhancement var3);
    }

    public static interface OutputFn
    extends Function<ContractCallStreamBuilder, ByteBuffer> {
        public static final OutputFn STANDARD_OUTPUT_FN = recordBuilder -> ReturnTypes.encodedRc(recordBuilder.status());
    }
}

