/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;

public interface TransferAuditTest {
    public boolean flagsAdjustment(@NonNull AccountAmount var1);

    public boolean flagsNftTransfer(@NonNull NftTransfer var1);

    public static boolean isAuditFlagRaised(@NonNull CryptoTransferTransactionBody op, @NonNull TransferAuditTest auditTest) {
        List hbarAdjusts = op.transfersOrElse(TransferList.DEFAULT).accountAmounts();
        for (AccountAmount adjust : hbarAdjusts) {
            if (!auditTest.flagsAdjustment(adjust)) continue;
            return true;
        }
        List tokenTransferLists = op.tokenTransfers();
        for (TokenTransferList tokenTransferList : tokenTransferLists) {
            List tokenAdjusts = tokenTransferList.transfers();
            for (AccountAmount adjust : tokenAdjusts) {
                if (!auditTest.flagsAdjustment(adjust)) continue;
                return true;
            }
            List nftTransfers = tokenTransferList.nftTransfers();
            for (NftTransfer nftTransfer : nftTransfers) {
                if (!auditTest.flagsNftTransfer(nftTransfer)) continue;
                return true;
            }
        }
        return false;
    }
}

