/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.handlers;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.hapi.utils.fee.SigValueObj;
import com.hedera.node.app.hapi.utils.fee.SmartContractFeeBuilder;
import com.hedera.node.app.service.contract.impl.ContractServiceComponent;
import com.hedera.node.app.service.contract.impl.exec.TransactionComponent;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hederahashgraph.api.proto.java.FeeData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Provider;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;

public abstract class AbstractContractTransactionHandler
implements TransactionHandler {
    protected final Provider<TransactionComponent.Factory> provider;
    protected final ContractServiceComponent component;
    protected final GasCalculator gasCalculator;
    protected final SmartContractFeeBuilder usageEstimator = new SmartContractFeeBuilder();

    protected AbstractContractTransactionHandler(@NonNull Provider<TransactionComponent.Factory> provider, @NonNull GasCalculator gasCalculator, @NonNull ContractServiceComponent component) {
        this.provider = Objects.requireNonNull(provider);
        this.gasCalculator = Objects.requireNonNull(gasCalculator);
        this.component = Objects.requireNonNull(component);
    }

    protected void bumpExceptionMetrics(@NonNull HederaFunctionality functionality, @NonNull Exception e) {
        PreCheckException pce;
        ContractMetrics contractMetrics = this.component.contractMetrics();
        contractMetrics.incrementRejectedTx(functionality);
        if (e instanceof PreCheckException && (pce = (PreCheckException)e).responseCode() == ResponseCodeEnum.INSUFFICIENT_GAS) {
            contractMetrics.incrementRejectedForGasTx(functionality);
        }
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        Objects.requireNonNull(feeContext);
        TransactionBody op = feeContext.body();
        return feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT).legacyCalculate(sigValueObj -> this.getFeeMatrices(this.usageEstimator, CommonPbjConverters.fromPbj((TransactionBody)op), (SigValueObj)sigValueObj));
    }

    @NonNull
    protected FeeData getFeeMatrices(@NonNull SmartContractFeeBuilder usageEstimator, @NonNull com.hederahashgraph.api.proto.java.TransactionBody txBody, @NonNull SigValueObj sigValObj) {
        throw new IllegalStateException("must be overridden if `calculateFees` _not_ overridden");
    }

    @NonNull
    protected TransactionComponent getTransactionComponent(@NonNull HandleContext context, @NonNull HederaFunctionality functionality) {
        return ((TransactionComponent.Factory)this.provider.get()).create(context, functionality);
    }
}

