/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.media.type;

import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public enum ParserMode {
    STRICT,
    RELAXED;

    private static final Map<String, MediaType> RELAXED_TYPES;

    static Optional<MediaType> findRelaxedMediaType(String value) {
        Objects.requireNonNull(value);
        MediaType relaxedValue = RELAXED_TYPES.get(value);
        return relaxedValue != null ? Optional.of(relaxedValue) : Optional.empty();
    }

    static {
        RELAXED_TYPES = Map.of("text", MediaTypes.TEXT_PLAIN);
    }
}

