/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.code;

import java.util.Arrays;
import java.util.BitSet;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.code.CodeSection;
import org.hyperledger.besu.evm.code.EOFLayout;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.RelativeJumpVectorOperation;

public final class CodeV1Validation {
    static final byte INVALID = 1;
    static final byte VALID = 2;
    static final byte TERMINAL = 4;
    static final byte VALID_AND_TERMINAL = 6;
    static final byte[] OPCODE_ATTRIBUTES = new byte[]{6, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 2, 2, 2, 6, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 6, 2, 2, 1, 1, 1, 1, 2, 1, 1, 6, 6, 1};
    static final int MAX_STACK_HEIGHT = 1024;
    static final byte[][] OPCODE_STACK_VALIDATION = new byte[][]{{0, 0, -1}, {2, 1, 1}, {2, 1, 1}, {2, 1, 1}, {2, 1, 1}, {2, 1, 1}, {2, 1, 1}, {2, 1, 1}, {3, 1, 1}, {3, 1, 1}, {2, 1, 1}, {2, 1, 1}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {2, 1, 1}, {2, 1, 1}, {2, 1, 1}, {2, 1, 1}, {2, 1, 1}, {1, 1, 1}, {2, 1, 1}, {2, 1, 1}, {2, 1, 1}, {1, 1, 1}, {2, 1, 1}, {2, 1, 1}, {2, 1, 1}, {2, 1, 1}, {0, 0, 0}, {0, 0, 0}, {2, 1, 1}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 1, 1}, {1, 1, 1}, {0, 1, 1}, {0, 1, 1}, {0, 1, 1}, {1, 1, 1}, {0, 1, 1}, {3, 0, 1}, {0, 1, 1}, {3, 0, 1}, {0, 1, 1}, {1, 1, 1}, {4, 0, 1}, {0, 1, 1}, {3, 0, 1}, {1, 1, 1}, {1, 1, 1}, {0, 1, 1}, {0, 1, 1}, {0, 1, 1}, {0, 1, 1}, {0, 1, 1}, {0, 1, 1}, {0, 1, 1}, {0, 1, 1}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {1, 0, 1}, {1, 1, 1}, {2, 0, 1}, {2, 0, 1}, {1, 1, 1}, {2, 0, 1}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 1, 1}, {0, 1, 1}, {0, 0, 1}, {1, 1, 1}, {2, 0, 1}, {4, 0, 1}, {0, 1, 1}, {0, 1, 2}, {0, 1, 3}, {0, 1, 4}, {0, 1, 5}, {0, 1, 6}, {0, 1, 7}, {0, 1, 8}, {0, 1, 9}, {0, 1, 10}, {0, 1, 11}, {0, 1, 12}, {0, 1, 13}, {0, 1, 14}, {0, 1, 15}, {0, 1, 16}, {0, 1, 17}, {0, 1, 18}, {0, 1, 19}, {0, 1, 20}, {0, 1, 21}, {0, 1, 22}, {0, 1, 23}, {0, 1, 24}, {0, 1, 25}, {0, 1, 26}, {0, 1, 27}, {0, 1, 28}, {0, 1, 29}, {0, 1, 30}, {0, 1, 31}, {0, 1, 32}, {0, 1, 33}, {1, 2, 1}, {2, 3, 1}, {3, 4, 1}, {4, 5, 1}, {5, 6, 1}, {6, 7, 1}, {7, 8, 1}, {8, 9, 1}, {9, 10, 1}, {10, 11, 1}, {11, 12, 1}, {12, 13, 1}, {13, 14, 1}, {14, 15, 1}, {15, 16, 1}, {16, 17, 1}, {2, 2, 1}, {3, 3, 1}, {4, 4, 1}, {5, 5, 1}, {6, 6, 1}, {7, 7, 1}, {8, 8, 1}, {9, 9, 1}, {10, 10, 1}, {11, 11, 1}, {12, 12, 1}, {13, 13, 1}, {14, 14, 1}, {15, 15, 1}, {16, 16, 1}, {17, 17, 1}, {2, 0, 1}, {3, 0, 1}, {4, 0, 1}, {5, 0, 1}, {6, 0, 1}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, -3}, {1, 0, 3}, {1, 0, 2}, {0, 0, 3}, {0, 0, -1}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {3, 1, 1}, {7, 1, 1}, {0, 0, 0}, {2, 0, -1}, {6, 1, 1}, {4, 1, 1}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {6, 1, 1}, {0, 0, 0}, {0, 0, 0}, {2, 0, -1}, {0, 0, -1}, {0, 0, 0}};

    private CodeV1Validation() {
    }

    public static String validateCode(EOFLayout eofLayout) {
        int sectionCount = eofLayout.getCodeSectionCount();
        for (int i = 0; i < sectionCount; ++i) {
            CodeSection cs = eofLayout.getCodeSection(i);
            String validation = CodeV1Validation.validateCode(eofLayout.getContainer().slice(cs.getEntryPoint(), cs.getLength()), sectionCount);
            if (validation == null) continue;
            return validation;
        }
        return null;
    }

    static String validateCode(Bytes code, int sectionCount) {
        int size = code.size();
        BitSet rjumpdests = new BitSet(size);
        BitSet immediates = new BitSet(size);
        byte[] rawCode = code.toArrayUnsafe();
        int attribute = 1;
        int pos = 0;
        while (pos < size) {
            int operationNum = rawCode[pos] & 0xFF;
            attribute = OPCODE_ATTRIBUTES[operationNum];
            if ((attribute & 1) == 1) {
                return String.format("Invalid Instruction 0x%02x", operationNum);
            }
            int pcPostInstruction = ++pos;
            if (operationNum > 95 && operationNum <= 127) {
                int multiByteDataLen = operationNum - 95;
                pcPostInstruction += multiByteDataLen;
            } else if (operationNum == 224 || operationNum == 225) {
                if (pos + 2 > size) {
                    return "Truncated relative jump offset";
                }
                int offset = Words.readBigEndianI16(pos, rawCode);
                int rjumpdest = (pcPostInstruction += 2) + offset;
                if (rjumpdest < 0 || rjumpdest >= size) {
                    return "Relative jump destination out of bounds";
                }
                rjumpdests.set(rjumpdest);
            } else if (operationNum == 226) {
                if (pos + 1 > size) {
                    return "Truncated jump table";
                }
                int jumpTableSize = RelativeJumpVectorOperation.getVectorSize(code, pos);
                if (jumpTableSize == 0) {
                    return "Empty jump table";
                }
                if ((pcPostInstruction += 1 + 2 * jumpTableSize) > size) {
                    return "Truncated jump table";
                }
                for (int offsetPos = pos + 1; offsetPos < pcPostInstruction; offsetPos += 2) {
                    int offset = Words.readBigEndianI16(offsetPos, rawCode);
                    int rjumpdest = pcPostInstruction + offset;
                    if (rjumpdest < 0 || rjumpdest >= size) {
                        return "Relative jump destination out of bounds";
                    }
                    rjumpdests.set(rjumpdest);
                }
            } else if (operationNum == 227) {
                if (pos + 2 > size) {
                    return "Truncated CALLF";
                }
                int section = Words.readBigEndianU16(pos, rawCode);
                if (section >= sectionCount) {
                    return "CALLF to non-existent section - " + Integer.toHexString(section);
                }
                pcPostInstruction += 2;
            }
            immediates.set(pos, pcPostInstruction);
            pos = pcPostInstruction;
        }
        if ((attribute & 4) != 4) {
            return "No terminating instruction";
        }
        if (rjumpdests.intersects(immediates)) {
            return "Relative jump destinations targets invalid immediate data";
        }
        return null;
    }

    static String validateStack(EOFLayout eofLayout) {
        for (int i = 0; i < eofLayout.getCodeSectionCount(); ++i) {
            String validation = CodeV1Validation.validateStack(i, eofLayout);
            if (validation == null) continue;
            return validation;
        }
        return null;
    }

    public static String validateStack(int codeSectionToValidate, EOFLayout eofLayout) {
        try {
            int initialStackHeight;
            CodeSection toValidate = eofLayout.getCodeSection(codeSectionToValidate);
            byte[] code = eofLayout.getContainer().slice(toValidate.entryPoint, toValidate.length).toArrayUnsafe();
            int codeLength = code.length;
            int[] stackHeights = new int[codeLength];
            Arrays.fill(stackHeights, -1);
            int thisWork = 0;
            int maxWork = 1;
            int[][] workList = new int[codeLength][2];
            int maxStackHeight = initialStackHeight = toValidate.getInputs();
            stackHeights[0] = initialStackHeight;
            workList[0][1] = initialStackHeight;
            int unusedBytes = codeLength;
            while (thisWork < maxWork) {
                int currentPC = workList[thisWork][0];
                int currentStackHeight = workList[thisWork][1];
                if (thisWork > 0 && stackHeights[currentPC] >= 0) {
                    if (stackHeights[currentPC] != currentStackHeight) {
                        return String.format("Jump into code stack height (%d) does not match previous value (%d)", stackHeights[currentPC], currentStackHeight);
                    }
                    ++thisWork;
                    continue;
                }
                stackHeights[currentPC] = currentStackHeight;
                while (currentPC < codeLength) {
                    int returnStackItems;
                    int stackOutputs;
                    int stackInputs;
                    int thisOp = code[currentPC] & 0xFF;
                    byte[] stackInfo = OPCODE_STACK_VALIDATION[thisOp];
                    byte pcAdvance = stackInfo[2];
                    if (thisOp == 227) {
                        int section = Words.readBigEndianU16(currentPC + 1, code);
                        stackInputs = eofLayout.getCodeSection(section).getInputs();
                        stackOutputs = eofLayout.getCodeSection(section).getOutputs();
                    } else {
                        stackInputs = stackInfo[0];
                        stackOutputs = stackInfo[1];
                    }
                    if (stackInputs > currentStackHeight) {
                        return String.format("Operation 0x%02X requires stack of %d but only has %d items", thisOp, stackInputs, currentStackHeight);
                    }
                    if ((currentStackHeight = currentStackHeight - stackInputs + stackOutputs) > 1024) {
                        return "Stack height exceeds 1024";
                    }
                    maxStackHeight = Math.max(maxStackHeight, currentStackHeight);
                    if (thisOp == 224 || thisOp == 225) {
                        int rvalue = Words.readBigEndianI16(currentPC + 1, code);
                        workList[maxWork] = new int[]{currentPC + rvalue + 3, currentStackHeight};
                        ++maxWork;
                    } else if (thisOp == 226) {
                        int immediateDataSize = (code[currentPC + 1] & 0xFF) * 2;
                        unusedBytes -= immediateDataSize;
                        int tableEnd = immediateDataSize + currentPC + 2;
                        for (int i = currentPC + 2; i < tableEnd; i += 2) {
                            int rvalue = Words.readBigEndianI16(i, code);
                            workList[maxWork] = new int[]{tableEnd + rvalue, currentStackHeight};
                            ++maxWork;
                        }
                        currentPC = tableEnd - 2;
                    } else if (thisOp == 228 && currentStackHeight != (returnStackItems = toValidate.getOutputs())) {
                        return String.format("Section return (RETF) calculated height 0x%x does not match configured height 0x%x", currentStackHeight, returnStackItems);
                    }
                    if (pcAdvance < 0) {
                        unusedBytes += pcAdvance;
                        break;
                    }
                    if (pcAdvance == 0) {
                        return String.format("Invalid Instruction 0x%02x", thisOp);
                    }
                    if ((currentPC += pcAdvance) >= stackHeights.length) {
                        return String.format("Dangling immediate argument for opcode 0x%x at PC %d in code section %d.", currentStackHeight, codeLength - pcAdvance, codeSectionToValidate);
                    }
                    stackHeights[currentPC] = currentStackHeight;
                    unusedBytes -= pcAdvance;
                }
                ++thisWork;
            }
            if (maxStackHeight != toValidate.maxStackHeight) {
                return String.format("Calculated max stack height (%d) does not match reported stack height (%d)", maxStackHeight, toValidate.maxStackHeight);
            }
            if (unusedBytes != 0) {
                return String.format("Dead code detected in section %d", codeSectionToValidate);
            }
            return null;
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            return "Internal Exception " + re.getMessage();
        }
    }
}

