/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import java.math.BigInteger;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class MulOperation
extends AbstractFixedCostOperation {
    static final Operation.OperationResult mulSuccess = new Operation.OperationResult(5L, null);

    public MulOperation(GasCalculator gasCalculator) {
        super(2, "MUL", 2, 1, gasCalculator, gasCalculator.getLowTierGasCost());
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        return MulOperation.staticOperation(frame);
    }

    public static Operation.OperationResult staticOperation(MessageFrame frame) {
        BigInteger a = new BigInteger(1, frame.popStackItem().toArrayUnsafe());
        BigInteger b = new BigInteger(1, frame.popStackItem().toArrayUnsafe());
        BigInteger c = a.multiply(b);
        byte[] cBytes = c.toByteArray();
        Bytes result = Bytes.wrap((byte[])cBytes);
        if (cBytes.length > 32) {
            result = result.slice(cBytes.length - 32, 32);
        }
        frame.pushStackItem(result);
        return mulSuccess;
    }
}

