/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.nativelib.secp256r1;

import java.util.Arrays;
import java.util.Objects;

public class Signature {
    private final byte[] r;
    private final byte[] s;
    private final byte v;

    public Signature(byte[] r, byte[] s, byte v) {
        this.r = r;
        this.s = s;
        this.v = v;
    }

    public byte[] getR() {
        return this.r;
    }

    public byte[] getS() {
        return this.s;
    }

    public byte getV() {
        return this.v;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Signature signature = (Signature)o;
        return this.v == signature.v && Arrays.equals(this.r, signature.r) && Arrays.equals(this.s, signature.s);
    }

    public int hashCode() {
        int result = Objects.hash(this.v);
        result = 31 * result + Arrays.hashCode(this.r);
        result = 31 * result + Arrays.hashCode(this.s);
        return result;
    }

    public String toString() {
        return "Signature{r=" + Arrays.toString(this.r) + ", s=" + Arrays.toString(this.s) + ", v=" + this.v + "}";
    }
}

