/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.crypto;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.logging.legacy.LogMarker;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.hiero.base.crypto.CryptographyException;
import org.hiero.base.crypto.KeyType;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.hiero.base.utility.CommonUtils;

public class SerializablePublicKey
implements SelfSerializable {
    private static final long CLASS_ID = 168124213989088473L;
    private static final int CLASS_VERSION = 2;
    private static final int MAX_KEY_LENGTH = 6144;
    private static final int MAX_ALG_LENGTH = 10;
    private PublicKey publicKey;
    private KeyType keyType;

    public SerializablePublicKey() {
    }

    public SerializablePublicKey(PublicKey publicKey) {
        if (publicKey == null) {
            throw new IllegalArgumentException("publicKey must not be null!");
        }
        this.publicKey = publicKey;
        this.keyType = KeyType.getKeyType(publicKey);
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public int getVersion() {
        return 2;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeInt(this.keyType.getAlgorithmIdentifier());
        out.writeByteArray(this.publicKey.getEncoded());
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        if (version == 1) {
            String algorithm = in.readNormalisedString(10);
            this.keyType = KeyType.valueOf(algorithm);
        } else {
            this.keyType = KeyType.getKeyType(in.readInt());
        }
        byte[] keyBytes = in.readByteArray(6144);
        this.publicKey = SerializablePublicKey.bytesToPublicKey(keyBytes, this.keyType.getAlgorithmName());
    }

    public static PublicKey bytesToPublicKey(byte[] bytes, String keyType) {
        try {
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(bytes);
            KeyFactory keyFactory = KeyFactory.getInstance(keyType);
            return keyFactory.generatePublic(publicKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException ex) {
            throw new CryptographyException(ex, LogMarker.EXCEPTION);
        }
    }

    public void deserializeVersion0(SerializableDataInputStream in, String algorithm) throws IOException {
        this.keyType = KeyType.valueOf(algorithm);
        byte[] keyBytes = in.readByteArray(6144);
        this.publicKey = SerializablePublicKey.bytesToPublicKey(keyBytes, algorithm);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerializablePublicKey that = (SerializablePublicKey)o;
        return this.publicKey.equals(that.publicKey) && this.keyType == that.keyType;
    }

    public long getClassId() {
        return 168124213989088473L;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("publicKey", (Object)CommonUtils.hex((byte[])this.publicKey.getEncoded())).append("keyType", (Object)this.keyType).toString();
    }
}

