/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractCallOperation;

public class CallCodeOperation
extends AbstractCallOperation {
    public CallCodeOperation(GasCalculator gasCalculator) {
        super(242, "CALLCODE", 7, 1, gasCalculator);
    }

    @Override
    protected Address to(MessageFrame frame) {
        return Words.toAddress(frame.getStackItem(1));
    }

    @Override
    protected Wei value(MessageFrame frame) {
        return Wei.wrap((Bytes)frame.getStackItem(2));
    }

    @Override
    protected Wei apparentValue(MessageFrame frame) {
        return this.value(frame);
    }

    @Override
    protected long inputDataOffset(MessageFrame frame) {
        return Words.clampedToLong(frame.getStackItem(3));
    }

    @Override
    protected long inputDataLength(MessageFrame frame) {
        return Words.clampedToLong(frame.getStackItem(4));
    }

    @Override
    protected long outputDataOffset(MessageFrame frame) {
        return Words.clampedToLong(frame.getStackItem(5));
    }

    @Override
    protected long outputDataLength(MessageFrame frame) {
        return Words.clampedToLong(frame.getStackItem(6));
    }

    @Override
    protected Address address(MessageFrame frame) {
        return frame.getRecipientAddress();
    }

    @Override
    protected Address sender(MessageFrame frame) {
        return frame.getRecipientAddress();
    }

    @Override
    public long gasAvailableForChildCall(MessageFrame frame) {
        return this.gasCalculator().gasAvailableForChildCall(frame, this.gas(frame), !this.value(frame).isZero());
    }
}

