/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.http2;

import io.helidon.common.buffers.BufferData;
import io.helidon.http.http2.Http2SettingBase;
import java.util.Map;

public interface Http2Setting<T> {
    public static final Http2Setting<Long> HEADER_TABLE_SIZE = new Http2SettingBase.NumberSetting("HEADER_TABLE_SIZE", 1, 4096L);
    public static final Http2Setting<Boolean> ENABLE_PUSH = new Http2SettingBase.BooleanSetting("ENABLE_PUSH", 2, true);
    public static final Http2Setting<Long> MAX_CONCURRENT_STREAMS = new Http2SettingBase.NumberSetting("MAX_CONCURRENT_STREAMS", 3, 0xFFFFFFFFL);
    public static final Http2Setting<Long> INITIAL_WINDOW_SIZE = new Http2SettingBase.NumberSetting("INITIAL_WINDOW_SIZE", 4, 65535L);
    public static final Http2Setting<Long> MAX_FRAME_SIZE = new Http2SettingBase.NumberSetting("MAX_FRAME_SIZE", 5, 16384L);
    public static final Http2Setting<Long> MAX_HEADER_LIST_SIZE = new Http2SettingBase.NumberSetting("MAX_HEADER_LIST_SIZE ", 6, 0xFFFFFFFFL);
    public static final Map<Integer, Http2Setting<?>> BY_ID = Map.of(HEADER_TABLE_SIZE.identifier(), HEADER_TABLE_SIZE, ENABLE_PUSH.identifier(), ENABLE_PUSH, MAX_CONCURRENT_STREAMS.identifier(), MAX_CONCURRENT_STREAMS, INITIAL_WINDOW_SIZE.identifier(), INITIAL_WINDOW_SIZE, MAX_FRAME_SIZE.identifier(), MAX_FRAME_SIZE, MAX_HEADER_LIST_SIZE.identifier(), MAX_HEADER_LIST_SIZE);

    public int identifier();

    public T defaultValue();

    public T read(BufferData var1);

    public void write(BufferData var1, T var2);
}

