/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.signature.impl;

import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.base.SignaturePair;
import com.hedera.hapi.node.base.ThresholdKey;
import com.hedera.node.app.hapi.utils.MiscCryptoUtils;
import com.hedera.node.app.signature.ExpandedSignaturePair;
import com.hedera.node.app.signature.SignatureExpander;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SignatureExpanderImpl
implements SignatureExpander {
    private static final Logger logger = LogManager.getLogger(SignatureExpanderImpl.class);
    private static final int ED25519_KEY_LENGTH = 32;
    private static final int ECDSA_COMPRESSED_KEY_LENGTH = 33;

    @Inject
    public SignatureExpanderImpl() {
    }

    @Override
    public void expand(@NonNull List<SignaturePair> sigPairs, @NonNull Set<ExpandedSignaturePair> expanded) {
        Objects.requireNonNull(sigPairs);
        Objects.requireNonNull(expanded);
        for (SignaturePair pair : sigPairs) {
            ExpandedSignaturePair maybeExpandedSigPair;
            long prefixLength = pair.pubKeyPrefix().length();
            if (prefixLength == 32L && pair.signature().kind() == SignaturePair.SignatureOneOfType.ED25519) {
                expanded.add(new ExpandedSignaturePair(SignatureExpanderImpl.asKey(pair), pair.pubKeyPrefix(), null, pair));
                continue;
            }
            if (prefixLength != 33L || pair.signature().kind() != SignaturePair.SignatureOneOfType.ECDSA_SECP256K1 || (maybeExpandedSigPair = ExpandedSignaturePair.maybeFrom(pair.pubKeyPrefix(), pair)) == null) continue;
            expanded.add(maybeExpandedSigPair);
        }
    }

    @Override
    public void expand(@NonNull Key key, @NonNull List<SignaturePair> originals, @NonNull Set<ExpandedSignaturePair> expanded) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(originals);
        Objects.requireNonNull(expanded);
        switch ((Key.KeyOneOfType)key.key().kind()) {
            case ED25519: {
                SignaturePair match = this.findMatch(key, originals);
                if (match == null) break;
                expanded.add(new ExpandedSignaturePair(key, key.ed25519OrThrow(), null, match));
                break;
            }
            case ECDSA_SECP256K1: {
                ExpandedSignaturePair maybeExpandedSigPair;
                SignaturePair match = this.findMatch(key, originals);
                if (match == null || (maybeExpandedSigPair = ExpandedSignaturePair.maybeFrom(key.ecdsaSecp256k1OrThrow(), match)) == null) break;
                expanded.add(maybeExpandedSigPair);
                break;
            }
            case KEY_LIST: {
                key.keyListOrElse(KeyList.DEFAULT).keys().forEach(k -> this.expand((Key)k, originals, expanded));
                break;
            }
            case THRESHOLD_KEY: {
                key.thresholdKeyOrElse(ThresholdKey.DEFAULT).keysOrElse(KeyList.DEFAULT).keys().forEach(k -> this.expand((Key)k, originals, expanded));
                break;
            }
        }
    }

    @Nullable
    public static Bytes decompressKey(@Nullable Bytes keyBytes) {
        if (keyBytes == null) {
            return null;
        }
        byte firstByte = keyBytes.getByte(0L);
        if (firstByte == 2 || firstByte == 3) {
            try {
                return Bytes.wrap((byte[])MiscCryptoUtils.decompressSecp256k1((byte[])keyBytes.toByteArray()));
            }
            catch (IllegalArgumentException e) {
                logger.warn("Unable to decompress ECDSA(secp256k1) key. Should never happen", (Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    private SignaturePair findMatch(@NonNull Key key, @NonNull List<SignaturePair> pairs) {
        block4: for (SignaturePair pair : pairs) {
            Bytes prefix = pair.pubKeyPrefix();
            SignaturePair.SignatureOneOfType sigType = (SignaturePair.SignatureOneOfType)pair.signature().kind();
            switch (sigType) {
                case ED25519: {
                    boolean validPrefixLength;
                    boolean matchingKeyType = key.key().kind() == Key.KeyOneOfType.ED25519;
                    boolean bl = validPrefixLength = prefix.length() <= 32L;
                    if (!matchingKeyType || !validPrefixLength || !key.ed25519OrThrow().matchesPrefix((RandomAccessData)prefix)) continue block4;
                    return pair;
                }
                case ECDSA_SECP256K1: {
                    boolean validPrefixLength;
                    boolean matchingKeyType = key.key().kind() == Key.KeyOneOfType.ECDSA_SECP256K1;
                    boolean bl = validPrefixLength = prefix.length() <= 33L;
                    if (!matchingKeyType || !validPrefixLength || !key.ecdsaSecp256k1OrThrow().matchesPrefix((RandomAccessData)prefix)) continue block4;
                    return pair;
                }
            }
        }
        return null;
    }

    @NonNull
    public static Key asKey(@NonNull SignaturePair pair) {
        return switch ((SignaturePair.SignatureOneOfType)pair.signature().kind()) {
            default -> throw new MatchException(null, null);
            case SignaturePair.SignatureOneOfType.ED25519 -> Key.newBuilder().ed25519(pair.pubKeyPrefix()).build();
            case SignaturePair.SignatureOneOfType.ECDSA_SECP256K1 -> Key.newBuilder().ecdsaSecp256k1(pair.pubKeyPrefix()).build();
            case SignaturePair.SignatureOneOfType.CONTRACT, SignaturePair.SignatureOneOfType.ECDSA_384, SignaturePair.SignatureOneOfType.RSA_3072, SignaturePair.SignatureOneOfType.UNSET -> throw new IllegalArgumentException("Unsupported cryptographic key: " + String.valueOf(pair.signature().kind()));
        };
    }
}

